/* $Id: ShortCut.java 152 2011-05-03 09:23:21Z ohura $ */
package smart_gs.reasoning_web.desktop.logical;

import javax.swing.JPanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.logical.GSResource;
import smart_gs.logical.StandardTextDocument;
import smart_gs.logical.URICreator;
import smart_gs.logical.XML2ResourceConverter;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.desktop.swingui.DesktopWindow;
import smart_gs.reasoning_web.desktop.swingui.view.DesktopElementView;
import smart_gs.reasoning_web.desktop.swingui.view.ShortCutView;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.XML2RWElementConverter;

public class ShortCut extends DesktopElement implements URIBearer {
	
	private GS_RWElement resource;
	private String uri;
	private String originalURI;
	private String oldVersionURI;
	
	public ShortCut(){
		super();
	}
	
	public ShortCut(GS_RWElement resource,String name,StandardTextDocument memo,
			String uri, String originalURI){
		super(DesktopWindow.getInstance().getRootFolder(),name,memo);
		this.resource = resource;
		this.setName(this.name);
		this.setURIs(uri, originalURI);
	}
	@Override
	public DesktopElementView createView() {
		return new ShortCutView();
	}
	
	public void open() {
		this.resource.show();
	}
	public void setParentFolder(DeskTopFolder parent) {
		this.parent = parent;
	}
	public Element createXMLElement(Document document) {
		Element element = document.createElement(URICreator.SHORTCUT);
		element.setAttribute("name",this.name);
		element.setAttribute("uri", this.getURI());
		element.setAttribute(GSResource.ORIGINAL_URI, this.originalURI);
		element.setAttribute("resourceURI",this.resource.getURI());
		element.appendChild(this.resource.createXMLElement(document));
		element.appendChild(this.memo.createXMLElement(document));
		return element;
	}
	public void setResouce(GS_RWElement resouce) {
		this.resource = resouce;
	}
	public static ShortCut restore(Element element) {
		String name = element.getAttribute("name");
		String uri = element.getAttribute("uri");
		String originalURI = element.getAttribute("originalURI");
		String source = element.getAttribute("source");
		ShortCut shortcut = new ShortCut();
		shortcut.setName(name);
		shortcut.setString(source);
		NodeList list = element.getChildNodes();
		for(int i=0;i<list.getLength();i++){
			if(list.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)list.item(i);
				if(elem.getNodeName().equals("standardDocument")){
					StandardTextDocument memo = (StandardTextDocument) XML2ResourceConverter.convert(elem);
					shortcut.setMemo(memo);
				}else{
					GS_RWElement resource = XML2RWElementConverter.convert((Element)list.item(i));
					shortcut.setResouce(resource);
				}
			}
		}
		shortcut.setURIs(uri, originalURI);
		return shortcut;
	}



	public JPanel createElementViewPanel() throws NoWayToShowException {
		return null;
	}

	public String getURI() {
		return this.uri;
	}

	public void show() {
		this.resource.show();
		
	}

	public GS_RWElement getResource() {
		return this.resource;
	}

	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}

	@Override
	public String getTypeString() {
		return URICreator.SHORTCUT;
	}

	@Override
	public void setURI(String uri) {
		this.uri = uri;
	}
	@Override
	public String getOriginalURI() {
		return this.originalURI;
	}
	@Override
	public void setOriginalURI(String originalURI) {
		this.originalURI = originalURI;
	}
	@Override
	public void setURIs(String uri, String originalURI) {
		URICreator.setURIs(this, uri, originalURI);
	}

	@Override
	public String getOldVersionURI() {
		return this.oldVersionURI;
	}

	@Override
	public void setOldVersionURI(String oldVersionURI) {
		this.oldVersionURI = oldVersionURI;
	}

}
