/* $Id: DeskTopFolder.java 152 2011-05-03 09:23:21Z ohura $ */
package smart_gs.reasoning_web.desktop.logical;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JPanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.logical.GSResource;
import smart_gs.logical.URICreator;
import smart_gs.reasoning_web.desktop.swingui.DesktopWindow;
import smart_gs.reasoning_web.desktop.swingui.FolderPanel;
import smart_gs.reasoning_web.desktop.swingui.view.DesktopElementView;
import smart_gs.reasoning_web.desktop.swingui.view.DesktopFolderView;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;

public class DeskTopFolder extends DesktopElement{
	
	private List<ShortCut> shortcuts;
	private List<DeskTopFolder> folders;
	
	public DeskTopFolder(DeskTopFolder parent,String name){
		super(parent,name,"<xml></xml>");
		//20071126 shimizu wrote;
		this.setName(name);
		this.shortcuts = new ArrayList<ShortCut>();
		this.folders = new ArrayList<DeskTopFolder>();
	}
	public DeskTopFolder(String name){
		super(DesktopWindow.getInstance().getRootFolder(),name,"<xml></xml>");
		this.shortcuts = new ArrayList<ShortCut>();
		this.folders = new ArrayList<DeskTopFolder>();
	}
	public void add(DesktopElement shortcut){
		if(shortcut instanceof ShortCut){
			this.shortcuts.add((ShortCut)shortcut);
		}else if(shortcut instanceof DeskTopFolder){
			this.folders.add((DeskTopFolder)shortcut);
		}
		this.notifyChange();
		ReasoningWebFrame.getInstance().getDesktopPanel().updateAll();
	}
	
	public void remove(DesktopElement folder){
		if(folder instanceof ShortCut){
			this.shortcuts.remove((ShortCut)folder);
		}else if(folder instanceof DeskTopFolder){
			this.folders.remove((DeskTopFolder)folder);
		}
		this.notifyChange();
	}
	public List<ShortCut> getShortCuts(){
		return this.shortcuts;
	}
	public List<DeskTopFolder> getFolders(){
		return this.folders;
	}
	
	public void open() {
		ReasoningWebFrame.getInstance().setMainPanel(new FolderPanel(this));
	}
	@Override
	public DesktopElementView createView() {
		return new DesktopFolderView();
	}
	public List<DesktopElement> getAllElements() {
		List<DesktopElement> elements = new ArrayList<DesktopElement>();
		elements.addAll(this.shortcuts);
		elements.addAll(this.folders);
		return elements;
	}
	public DeskTopFolder getFolder(Point point) {
		for(int i=0;i<this.folders.size();i++){
			if(this.folders.get(i).getView().contains(point)){
				return this.folders.get(i);
			}
		}
		return null;
	}
	public DeskTopFolder getFolder(String name) {
		for(int i=0;i<this.folders.size();i++){
			if(this.folders.get(i).getName().equals(name)){
				return this.folders.get(i);
			}
		}
		return null;
	}
	public Element createXMLElement(Document document){
		
		Element element = document.createElement("desktopFolder");
		element.setAttribute("name",this.name);
		element.setAttribute("source",this.memo.getSource());
		for(int i=0;i<this.folders.size();i++){
			Element elem = this.folders.get(i).createXMLElement(document);
			element.appendChild(elem);
		}
		
		for(int i=0;i<this.shortcuts.size();i++){
			Element elem = this.shortcuts.get(i).createXMLElement(document);
			element.appendChild(elem);
		}
		
		return element;
	}

	public static DeskTopFolder restore(Element element) {
		String name = element.getAttribute("name");
		String source = element.getAttribute("source");
		DeskTopFolder folder = new DeskTopFolder(name);
		folder.setString(source);
		NodeList list = element.getElementsByTagName("desktopFolder");

		for(int i=0;i<list.getLength();i++){
			DeskTopFolder childFolder = DeskTopFolder.restore((Element)list.item(i));
			folder.add(childFolder);
		}
		
		list = element.getElementsByTagName("shortcut");
		for(int i=0;i<list.getLength();i++){
			if(!list.item(i).getParentNode().equals(element)){
				continue;
			}
			ShortCut shortcut = ShortCut.restore((Element)list.item(i));
			folder.add(shortcut);
			shortcut.setParent(folder);
		}
		
		return folder;
	}
	public JPanel createElementViewPanel() throws NoWayToShowException {
		return null;
	}
	public String getURI() {
		return null;
	}
	public void show() {
		this.open();
	}
	public boolean hasFolder(String name) {
		for(int i=0;i<this.folders.size();i++){
			if(this.folders.get(i).getName().equals(name)){
				return true;
			}
		}
		return false;
	}
	public GSResource getResource(String uri) {
		for(int i=0;i<this.shortcuts.size();i++){

			GS_RWElement resource =  (GS_RWElement) this.shortcuts.get(i).getResource();
			if(resource.getURI().equals(uri)){
				return (GSResource)resource;
			}
			resource = this.shortcuts.get(i).getMemo().getSegments(uri);
			if(resource != null){
				return (GSResource)resource;
			}
		}
		for(int i=0;i<this.folders.size();i++){
			GSResource resource = this.folders.get(i).getResource(uri);
			if(resource != null){
				return resource;
			}
		}
		return null;
	}
	@Override
	public String createURI() {
		return null;
	}
	@Override
	public String getTypeString() {
		return URICreator.DESKTOP_FOLDER;
	}
}
