/* $Id: UsersNoteDirectory.java 155 2011-05-03 10:31:26Z ohura $ */
package smart_gs.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.swing.tree.DefaultMutableTreeNode;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.logical.visitor.Visitor;

public class UsersNoteDirectory extends GSResource{
	
	private List<GSResource> resources;
	private UsersNoteDirectory parent;
	
	// Constructor for the root
	public UsersNoteDirectory(String uri) {
		// TODO 2011.04.19 shayashi vؓcURIɕύX
//		super(parent.getURI()+name+File.separator);
		super();
		this.setName(name);
		this.parent = null;
		this.resources = new ArrayList<GSResource>();
	}
	
	public UsersNoteDirectory(UsersNoteDirectory parent,String name){
		// TODO 2011.04.19 shayashi vؓcURIɕύX
//		super(parent.getURI()+name+File.separator);
		super();
		this.setName(name);
		this.parent = parent;
		this.resources = new ArrayList<GSResource>();
	}

	public List<GSResource> getResources(){
		return this.resources;
	}

	public void setResources(List<GSResource> newResources){
		this.resources = newResources;
	}


	
	public List<UsersNote> getUsersNotes(){
		List<UsersNote> results = new ArrayList<UsersNote>();
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof UsersNote){
				results.add((UsersNote)resource);
			}else if(resource instanceof UsersNoteDirectory){
				results.addAll(((UsersNoteDirectory)resource).getUsersNotes());
			}
		}
		return results;
	}
	public List<UsersNoteDirectory> getUsersNoteDirectories(){
		List<UsersNoteDirectory> results = new ArrayList<UsersNoteDirectory>();
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof UsersNoteDirectory){
				results.add((UsersNoteDirectory)resource);
				results.addAll(((UsersNoteDirectory)resource).getUsersNoteDirectories());
			}
		}
		return results;
	}
	public void addResource(GSResource resource){
		this.resources.add(resource);
	}

	public String toString(){
//		2011.03.28 shayashi changed
		//2007/11/20 kazuhiro kobayshi
//		return this.userName;
		return this.name;
	}
	public String getPath() {
		String path = "";
		if(this.parent != null){
			path = this.parent.getPath();
		}else{
			return path;
		}
		return path+this.getName()+"/";
	}

	public void restore(Element element) {
		this.resources.clear();
		NodeList nodes = element.getChildNodes();
		for(int i=0;i<nodes.getLength();i++){
			Node node = (Node) nodes.item(i);
			if(node.getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)node;
				String tagname = elem.getNodeName();
				/*
				 *@ResourceɂΉB
				 */
				if(tagname.equals("usersNote")){
					UsersNote UsersNote = XML2ResourceConverter.getUsersNote(elem);
					UsersNoteTree.getInstance().registorUsersNote(UsersNote);
					this.addResource(UsersNote);
				}else if(tagname.equals("usersNoteDirectory")){
					String name = elem.getAttribute(GSResource.NAME);
					String uri = elem.getAttribute(GSResource.URI);
					String filename = elem.getAttribute("filename");
					UsersNoteDirectory directory = new UsersNoteDirectory(this,name);
					UsersNoteTree.getInstance().registorUsersNoteDirectory(directory);
					this.addResource(directory);
					directory.setURI(uri);
					directory.restore(elem);
				}
			}
		}
	}
	public void setTree(DefaultMutableTreeNode parent){
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof UsersNote){
				parent.add(new DefaultMutableTreeNode(resource));
			}else if(resource instanceof UsersNoteDirectory){
				DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(resource);
				parent.add(newNode);
				((UsersNoteDirectory)resource).setTree(newNode);
				
			}
		}
	}
	
	public void remove(UsersNote  UsersNote){
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof UsersNote){
				if(resource.getURI().equals(UsersNote.getURI())){
					resources.remove(i);
					break;
				}
			}else if(resource instanceof UsersNoteDirectory){
				((UsersNoteDirectory)resource).remove(UsersNote);
			}
		}
	}
	public void removeDirectory(UsersNoteDirectory UsersNoteDirectory){
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof UsersNoteDirectory){
				if(resource.getURI().equals(UsersNoteDirectory.getURI())){
					resources.remove(i);
					break;
				}
				((UsersNoteDirectory)resource).removeDirectory(UsersNoteDirectory);
			}
		}
	}
	public void removeAllChildren(){
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof UsersNote){
				resources.remove(i);
			}else if(resource instanceof UsersNoteDirectory){
				((UsersNoteDirectory)resource).removeAllChildren();
				resources.remove(i);
			}
		}
	}
	
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	
	public void sort(){
		Collections.sort(resources, new Comparator<GSResource>() {   
			public int compare(GSResource o1, GSResource o2) {
				if((o1 instanceof UsersNote) && (o2 instanceof UsersNote)){
					if(((UsersNote)o1).getPageViewIndex() > ((UsersNote)o2).getPageViewIndex()){
						return 1;
					}else{
						return -1;
					}
				}
				return 0;
			}
		});   
	}

	@Override
	public String createURI() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getTypeString() {
		// TODO Auto-generated method stub
		return null;
	}
}
