/* $Id: UsersNote.java 153 2011-05-03 09:42:32Z ohura $ */
package smart_gs.logical;

import smart_gs.GSConstants;
import smart_gs.logical.visitor.Visitor;

public class UsersNote extends SmartDocument{
	
	public static final String USERSNOTE = URICreator.USERS_NOTE;
	private static int pageIndex = 0;
	private int _pageVIewIndex;

	public UsersNote(UsersNoteDirectory parentUsersNoteDir, String name) {
		super("smart://usersNote/" + System.currentTimeMillis());
		this.source = "<xml><html></html></xml>";
		int id = this.hashCode();
		//071212 shimizu wrote;
		this.name = "";
		this.setId(id);
		this._pageVIewIndex = pageIndex++;
//		this.setURIs(uri, originalURI);
	}
	
	public UsersNote(String name, String uri, String originalURI){
		super();
		this.source = "<xml><html></html></xml>";
		this.setName(name);
		int id = this.hashCode();
		//071212 shimizu wrote;
		this.setId(id);
		this._pageVIewIndex = pageIndex++;
		this.setURIs(uri, originalURI);
	}

	//1028 shimizu wrote;
	public GSResource getTextSegmentByURI(String uri) {
		for(int i=0;i<this.segments.size();i++){
			if(this.segments.get(i).getURI().equals(uri)){
				return this.segments.get(i);
			}
		}
		return null;
	}

	
	@Override
	public String toString() {
//		return this._pageVIewIndex +": " + this.name;
		return this.name;
	}

	
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	//20080931 hashimoto
	public String getName(){
		return this.name;
	}
	// ADD NorthGrid
	/**
	 * \pCfbNXݒ
	 */
	public void setPageViewIndex(int number){
		_pageVIewIndex = number;
	}
	// ADD NorthGrid
	/**
	 * \pCfbNX擾
	 */
	public int getPageViewIndex(){
		return _pageVIewIndex;
	}

	public Integer getPageIndex() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}

	@Override
	public String getTypeString() {
		return URICreator.USERS_NOTE;
	}

}