/* $Id: URISolver.java 152 2011-05-03 09:23:21Z ohura $ */
package smart_gs.logical;

import javax.swing.JOptionPane;

import reasoning_web.logical.ExplanatoryNote;
import smart_gs.GSConstants;
import smart_gs.reasoning_web.Zombie;
import smart_gs.reasoning_web.logical.ExpNoteManager;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;

/**
 * TODO
 * Ƃ̂
 *
 */
public class URISolver {
	
	private static final String HEADER = URIObject.HEADER;
	private static final String SEP1 = URIObject.SEP1;
	private static final String SEP2 = URIObject.SEP2;
	private static final String SEP3 = URIObject.SEP3;
	private static final String SEP4 = URIObject.SEP4;
	
	public static Region getRegion(String uri){
		Region region = null;
		Spread spread = SpreadTree.getInstance().getSpreadByURI(uri);
		if(spread == null){
			return null;
		}
		region = spread.getRegionByURI(uri);
		return region;
	}

	public static GSResource getUsersNote(String uri){
		GSResource usersNote = UsersNoteTree.getInstance().getUsersNoteByURI(uri);
		return usersNote;
	}
	public static GSResource getSpreadResource(String uri){
		Spread spread = SpreadTree.getInstance().getSpreadByURI(uri);
		GSResource resource = spread.getResource(uri);
		return resource;
	}
	
	//2011/03/29 kukita
	public static GSResource getTextSegmentFromUsersNote(String uri) {
		UsersNote usersNote = (UsersNote)UsersNoteTree.getInstance().getUsersNoteByURI(uri);
		GSResource textSegment = usersNote.getTextSegmentByURI(uri);
		return textSegment;
	}
	
	// 20080909 hashimoto wrote
	public static Spread getSpread(String uri){
		Spread spread = SpreadTree.getInstance().getSpreadByURI(uri);
		return spread;
	}
	
	public static GSResource getResource(String uri){
//		2011.02.17 shayashi changed much.
//		2011/03/31 kukita changed
		GSResource resource = null;
		if(uri.contains(GSConstants.URI_HEADER+"usersNote/")
				// 2011.01.04 shayashi for upper-compatibility
				|| uri.contains(GSConstants.URI_HEADER+"presentation/")){
			resource = getUsersNote(uri);
		}else if(uri.contains("//explanatory")){
			resource = ExpNoteManager.getInstance().getResource(uri);
		}else if(uri.contains("//package")){
			//	TODO commented by shayashi 2011.02.17. What is this for?
			resource = null;
		}else if(uri.contains("//document")){
			resource = ReasoningWebFrame.getInstance().getDesktopPanel().getResource(uri);
		}else if (isATextSegmentFromUsersNote(uri)) {
			resource = getTextSegmentFromUsersNote(uri);
		}else if (isATextSegmentFromExplanatoryNote(uri)) {
			resource = getTextSegmentFromExplanatoryNote(uri);
		} else {
			resource = getSpreadResource(uri);
		}
		
		if (resource != null) {
			return resource;
		}else {
//			TODO Create Zombie (usrsNote, explanatory, package, document(?), Spread)
//			How@about the other GSResource? E.g. TextSegment,Polygon,...?
//			The zombie... should be returned instead of null.
			JOptionPane.showMessageDialog(null, "Resource "+ uri + " was not found");
//			return getResource("smart://zombie.jpg");
//			return getResource("smart://zombie.jpg");
			return new Zombie();
		}
		
	}

	private static GSResource getTextSegmentFromExplanatoryNote(String uri) {
		GSExplanatoryNote expNote = (GSExplanatoryNote)ExpNoteManager.getInstance()
			.getExplanatoryNoteByTextSegmentURI(uri);
		GSResource textSegment = expNote.getTextSegmentByURI(uri);
		return textSegment;
	}

	public static boolean isATextSegmentURI(String uri) {
		return uri.startsWith(URIObject.HEADER + URIObject.TEXT_SEGMENT);
	}
	public static boolean isATextSegmentFromUsersNote(String uri) {
		return isATextSegmentURI(uri) 
			&& uri.contains(URIObject.SEP2 + URIObject.USERS_NOTE) 
			&& !uri.contains(URIObject.SEP2 + URIObject.EXPLANATORY_NOTE);
	}

	public static boolean isATextSegmentFromFirstIDAT(String uri) {
		return isATextSegmentURI(uri) 
			&& uri.contains(URIObject.SEP2 + URIObject.FIRST_IDAT) 
			&& !uri.contains(URIObject.SEP2 + URIObject.EXPLANATORY_NOTE);
	}

	public static boolean isATextSegmentFromSecondIDAT(String uri) {
		return isATextSegmentURI(uri) 
			&& uri.contains(URIObject.SEP2 + URIObject.SECOND_IDAT) 
			&& !uri.contains(URIObject.SEP2 + URIObject.EXPLANATORY_NOTE);
	}

	public static boolean isATextSegmentFromThirdIDAT(String uri) {
		return isATextSegmentURI(uri) 
			&& uri.contains(URIObject.SEP2 + URIObject.THIRD_IDAT) 
			&& !uri.contains(URIObject.SEP2 + URIObject.EXPLANATORY_NOTE);
	}

	public static boolean isATextSegmentFromExplanatoryNote(String uri) {
		return isATextSegmentURI(uri) 
			&& uri.contains(URIObject.SEP2 + URIObject.EXPLANATORY_NOTE);		
	}
	
	
	public static boolean isASmartDocumentURI(String uri) {
		return uri.startsWith(HEADER + URIObject.STANDARD_TEXT_DOCUMENT)
				|| uri.startsWith(HEADER + URIObject.FIRST_IDAT)
				|| uri.startsWith(HEADER + URIObject.SECOND_IDAT)
				|| uri.startsWith(HEADER + URIObject.THIRD_IDAT)
				|| uri.startsWith(HEADER + URIObject.EXPLANATORY_NOTE)
				|| uri.startsWith(HEADER + URIObject.USERS_NOTE);
	}

	public static boolean isASmartDocumentOldVersionURI(String uri) {
		return isAStandardTextDocumentOldVersionURI(uri)
			|| isAUsersNoteOldVersionURI(uri)
			|| isAnExplanatoryNoteOldVersionURI(uri)
			|| isAnIDATOldVersionURI(uri);
	}
	public static boolean isAStandardTextDocumentOldVersionURI(String uri) {
		return (uri.startsWith(HEADER + "document") && countSeparatorInURI(uri) == 4);
	}
	public static boolean isAUsersNoteOldVersionURI(String uri) {
		return (uri.startsWith(HEADER + "presentation") && countSeparatorInURI(uri) == 5);
	}
	public static boolean isAnExplanatoryNoteOldVersionURI(String uri) {
		return (uri.startsWith(HEADER + "explanatory") && countSeparatorInURI(uri) == 3);
	}
	public static boolean isAnIDATOldVersionURI(String uri) {
		return isAFirstIDATOldVersionURI(uri)
			|| isASecondIDATOldVersionURI(uri)
			|| isAThirdIDATOldVersionURI(uri);
	}
	public static boolean isAFirstIDATOldVersionURI(String uri) {
		return uri.endsWith("/transcription/");
	}
	public static boolean isASecondIDATOldVersionURI(String uri) {
		return uri.endsWith("/annotation/");
	}
	public static boolean isAThirdIDATOldVersionURI(String uri) {
		return uri.endsWith("/transcription/");
	}
	public static boolean isATextSegmentOldVersionURI(String uri) {
		return isASmartDocumentOldVersionURI(chopIdFromOldVersionURI(uri));
	}
	public static int countSeparatorInURI(String uri) {
		String sep = URIObject.SEP1;
		int count = 0;
		for (int i = 0; i < uri.length(); i++) {
			if (uri.substring(i,i+1).equals(sep)) {
				count++;
			}
		}
		return count;
	}
	public static String chopIdFromOldVersionURI(String uri) {
		for (int i = uri.length(); i >= 0; i-- ) {
			if (uri.substring(i-1,i).equals("/")) {
				return uri.substring(0, i-1);
			}
		}
		return null;
	}
	public static boolean isATextSegmentOldVersionURIFromFirstIDAT(String uri) {
		return isAFirstIDATOldVersionURI(chopIdFromOldVersionURI(uri));
	}
	public static boolean isATextSegmentOldVersionURIFromSecondIDAT(String uri) {
		return isASecondIDATOldVersionURI(chopIdFromOldVersionURI(uri));
	}
	public static boolean isATextSegmentOldVersionURIFromThirdIDAT(String uri) {
		return isAThirdIDATOldVersionURI(chopIdFromOldVersionURI(uri));
	}
	public static void main(String[] args) {
		String s = "smart://abc/def/0";
		System.out.println(chopIdFromOldVersionURI(s));

	}


}
