/* $Id: URIObject.java 155 2011-05-03 10:31:26Z ohura $ */
package smart_gs.logical;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.GSConstants;

public class URIObject {
	public static final String ANONYMOUS_USER = "AnonymousUser";
	public static String LAST_CREATED_DATE;
	public static int ADDITIONAL_EXTENSION;

	public static final String HEADER = GSConstants.URI_HEADER;
	public static final String SEP1 = "/";
	public static final String SEP2 = "^";
	public static final String SEP3 = "#";
	public static final String SEP4 = "@";

	public static final String SPREAD_DIRECTORY = "directory";
	public static final String SPREAD = "spread";
	public static final String REGION = "region";
	public static final String LINE_SEGMENT = "linesegment";
	public static final String BOOKMARK = "bookmark";
	public static final String POLYGON = "polygon";
	public static final String RECTANGLE = "rect";
	public static final String MARKER = "marker";
	public static final String LINE = "line";
	public static final String MEMOPAD = "memopad";
	public static final String STANDARD_TEXT_DOCUMENT = "document";
	public static final String IDAT = "Idat";
	public static final String FIRST_IDAT = "firstIdat";
	public static final String SECOND_IDAT = "secondIdat";
	public static final String THIRD_IDAT = "thirdIdat";
	public static final String USERS_NOTE = "usersNote";
	public static final String EXPLANATORY_NOTE = "explanatory";
	public static final String TEXT_SEGMENT = "segment";
	public static final String CONNECTION = "connection";
	public static final String RWPACKAGE = "package";
	public static final String GS_RWPACKAGE = "gsRWPackage";
	public static final String GSQUERY = "query";
	public static final String SHORTCUT = "shortcut";
	public static final Object BACKET = "backet";
	public static final String DESKTOP_FOLDER = "desktopFolder";

	private String type;
	private URIObject container;
	private URIObject source;
	private URIObject target;
	private String name;
	private String usersName;
	private String date;
	private String exception = "UNKNOWN";
	
	public URIObject(String type) {
		this.type = type;
		this.usersName = getUsersName();
		String date = getDate();
		String addExt = getAdditionalExtension(date);
		this.date = date + addExt;
	}
	public URIObject(String type, String usersName, String date) {
		this(type);
		this.usersName = usersName;
		this.date = date;		
	}
	public static URIObject parse(String arg) {
		URIObject uri = new URIObject(getTypeFrom(arg));
		//debug
		System.out.println("debug print from URI, parse()");
		System.out.println("  uri: " + arg);
		System.out.println("  type: " + uri.type);
		if (uri.type == null) {
			uri.exception = arg;
			return uri;
		}
		if (uri.type.equals(SPREAD_DIRECTORY)) {
			String body = cdr(chopHeader(arg));
			System.out.println("  body: " + body);
			if (cdr(body).equals("")) {
				System.out.println("  cdr is empty");				
				uri.container = null;
				uri.name = "root";
				return uri;
			} else {
				System.out.println("  cdr is not empty");				
				System.out.println("  name: " + getLast(body));				
				uri.container = parse(SPREAD_DIRECTORY + SEP1 + chopLast(body));
				uri.name = getLast(body);
				return uri;
			}
		}
		uri.usersName = getUsersNameFrom(arg);
		System.out.println("  usersName: " + uri.usersName);
		uri.date = getDateFrom(arg);
		System.out.println("  date: " + uri.date);
		if (isNamed(arg)) {
			uri.name = getNameFrom(arg);
			System.out.println("  name: " + uri.name);
		}
		if (hasAParent(arg)) {
			System.out.println("  parent uri: " + getParentURIFrom(arg));
			uri.container = parse(getParentURIFrom(arg));
		}
		if (getTypeFrom(arg).equals(CONNECTION)) {
			System.out.println("  source uri: " + getSourceURIFrom(arg));
			System.out.println("  target uri: " + getTargetURIFrom(arg));
			uri.source = parse(getSourceURIFrom(arg));
			uri.target = parse(getTargetURIFrom(arg));
		}
		return uri;
	}
	public String toStringWithoutHeader() {
		//debug
		System.out.println("debug print from URI, toStringWithoutHeader()");
		if (this.type == null) {
			return this.exception;
		}
		String uri = this.type + SEP1;
		System.out.println("  uri: " + uri + "...");
		if (this.type.equals(SPREAD_DIRECTORY)) {
			if (this.container == null) {
				uri += "root" + SEP1;
				System.out.println("  uri: " + uri);
				return uri;
			} else {
				uri += cdr(this.container.toStringWithoutHeader()) 
					+ this.name + SEP1;
				System.out.println("  uri: " + uri);
				return uri;
			}
		}
		if (this.name != null) {
			System.out.println("  name: " + this.name);
			uri += this.name + SEP1;
			System.out.println("  uri: " + uri + "...");
		}
		uri += this.usersName + SEP1 + this.date + SEP1;
		System.out.println("  uri: " + uri + "...");
		if (this.container != null) {
			uri += SEP2 + this.container.toStringWithoutHeader();
			System.out.println("  uri: " + uri);
		}
		if (this.type.equals(CONNECTION)) {
			uri += SEP3 + this.source.toStringWithoutHeader();
			uri += SEP4 + this.target.toStringWithoutHeader();
			System.out.println("  uri: " + uri);
		}
		return uri;
	}
	@Override
	public String toString() {
		return HEADER + this.toStringWithoutHeader();
	}
	
	public Element createXMLElement(Document document) {
		Element element = document.createElement("uri");
		element.setAttribute("type",this.type);
		element.setAttribute("name",this.name);
		element.setAttribute("usersName",this.usersName);	
		element.setAttribute("date",this.date);
		element.setAttribute("exception",this.exception);
		element.appendChild(this.container.createXMLElement(document));
		element.appendChild(this.source.createXMLElement(document));
		element.appendChild(this.target.createXMLElement(document));
		return element;
	}
	public static URIObject restore(Element elem) {
		String type = elem.getAttribute("type");
		URIObject uri = new URIObject(type);
		uri.name = elem.getAttribute("name");
		uri.usersName = elem.getAttribute("usersName");
		uri.date = elem.getAttribute("date");
		uri.exception = elem.getAttribute("exception");
		uri.container = restore((Element)elem.getChildNodes().item(0));
		uri.source = restore((Element)elem.getChildNodes().item(1));
		uri.target = restore((Element)elem.getChildNodes().item(2));
		return uri;
	}
	
	
	public static String chopHeader(String uri) {
		if (uri.startsWith(HEADER)) {
			return chop(uri, HEADER);
		} else {
			return uri;
		}
	}
	public static String getTypeFrom(String uri) {
		return car(chopHeader(uri));
	}
	public static String getNameFrom(String uri) {
		if (isNamed(uri)) {
			return car(cdr(chopHeader(uri)));
		} else {
			return "";
		}
	}
	public static String getUsersNameFrom(String uri) {
		if (isNamed(uri)) {
			return car(cdr(cdr(chopHeader(uri))));
		} else {
			return car(cdr(chopHeader(uri)));
		}
	}
	public static String getDateFrom(String uri) {
		if (isNamed(uri)) {
			return car(cdr(cdr(cdr(chopHeader(uri)))));
		} else {
			return car(cdr(cdr(chopHeader(uri))));
		}
	}
	
	public static String chop(String arg0, String arg2) {
		return arg0.substring(arg2.length());
	}
	public static String car(String arg) {
		if (indexOfNextSeparator(arg) >= 0) {
			return arg.substring(0, indexOfNextSeparator(arg));
		} else {
			return null;
		}
	}
	public static String cdr(String arg) {
		if (indexOfNextSeparator(arg) >= 0) {
			return arg.substring(indexOfNextSeparator(arg) + 1);
		} else {
			return null;
		}
	}
	public static int indexOfNextSeparator(String arg) {
		for (int i = 0; i < arg.length(); i++) {
			if (startWithASeparator(arg.substring(i))) {
				return i;
			}
		}
		return -1;
	}
	public static boolean startWithASeparator(String arg) {
		return arg.startsWith(SEP1)
				|| arg.startsWith(SEP2)
				|| arg.startsWith(SEP3)
				|| arg.startsWith(SEP4);
	}
	public static String getParentURIFrom(String uri) {
		if (hasAParent(uri)) {
			int index = uri.indexOf(SEP2);
			if (index >= 0) {
				return uri.substring(uri.indexOf(SEP2) + 1);
			} else {
				return null;
			}
		} else {
			return null;
		}
	}
	public static String getSourceURIFrom(String uri) {
		String type = getTypeFrom(uri);
		if (type.equals(CONNECTION)) {
			int beginIndex = uri.indexOf(SEP3)+1;
			int countSep3 = 1;
			for (int endIndex = beginIndex; endIndex < uri.length(); endIndex++) {
				if (uri.substring(endIndex).startsWith(SEP3)) {
					countSep3++;
				} else if (uri.substring(endIndex).startsWith(SEP4)) {
					countSep3--;
				}
				if (countSep3 == 0) {
					return uri.substring(beginIndex, endIndex);
				}
			}
			return "";
		} else {
			return "";
		}
	}
	public static String getTargetURIFrom(String uri) {
		String type = getTypeFrom(uri);
		if (type.equals(CONNECTION)) {
			int countSep3 = 1;
			for (int beginIndex = uri.indexOf(SEP3)+1; 
				beginIndex < uri.length(); beginIndex++) {
				if (uri.substring(beginIndex).startsWith(SEP3)) {
					countSep3++;
				} else if (uri.substring(beginIndex).startsWith(SEP4)) {
					countSep3--;
				}
				if (countSep3 == 0) {
					return uri.substring(beginIndex + 1);
				}
			}
			return "";
		} else {
			return "";
		}
	}
	public static boolean isNamed(String uri) {
		String type = getTypeFrom(uri);
		return type.equals(SPREAD)
				|| type.equals(USERS_NOTE)
				|| type.equals(GS_RWPACKAGE)
				|| type.equals(GSQUERY);
	}
	public static boolean hasAParent(String uri) {
		String type = getTypeFrom(uri);
		return type.equals(SPREAD)
				|| type.equals(FIRST_IDAT)
				|| type.equals(SECOND_IDAT)
				|| type.equals(THIRD_IDAT)
				|| type.equals(REGION)
				|| type.equals(RECTANGLE)
				|| type.equals(MARKER)
				|| type.equals(POLYGON)
				|| type.equals(LINE)
				|| type.equals(LINE_SEGMENT)
				|| type.equals(MEMOPAD)
				|| type.equals(BOOKMARK)
				|| type.equals(EXPLANATORY_NOTE)
				|| type.equals(TEXT_SEGMENT)
				|| type.equals(USERS_NOTE)
				|| type.equals(GSQUERY)
				|| type.equals(SHORTCUT);
	}
	private static String getLast(String arg) {
		if (cdr(arg).equals("")) {
			return car(arg);
		} else {
			return getLast(cdr(arg));
		}
	}
	private static String chopLast(String arg) {
		if (cdr(arg).equals("")) {
			return "";
		} else {
			return car(arg) + SEP1 + chopLast(cdr(arg));
		}
	}

	public String getType() {
		return this.type;
	}
	private static String getUsersName() {
		String name = Preference.getInstance().getUserName();
		if (name == null || name == "") {
			return ANONYMOUS_USER;
		} else {
			return modifyName(name);
		}		
	}
	private static String getAdditionalExtension(String date) {
		String s = "";
		if (date.equals(LAST_CREATED_DATE)) {
			ADDITIONAL_EXTENSION++;
			s = "(" + Integer.toString(ADDITIONAL_EXTENSION) + ")";
		} else {
			ADDITIONAL_EXTENSION = 0;
		}
		return s;
	}
	private static String getDate() {
		Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
		cal.setTime(new Date());
		String y = Integer.toString(cal.get(Calendar.YEAR));
		String m = adjust(cal.get(Calendar.MONTH) + 1);
		String d = adjust(cal.get(Calendar.DATE));
		String h = adjust(cal.get(Calendar.HOUR_OF_DAY));
		String min = adjust(cal.get(Calendar.MINUTE));
		String sec = adjust(cal.get(Calendar.SECOND));
		//String ms = cal.get(Calendar.MILLISECOND);
		return y + m + d + h + min + sec;
	}
	private static String adjust(int x) {
		if (x < 10) {
			return "0" + Integer.toString(x);
		} else {
			return Integer.toString(x);
		}
	}
	public static final String modifyName(String name) {
		if (name.equals("")) {
			return "UNNAMED";
		} else {
			return name.replace(" ", "?");
		}
	}
	public static final String getURIWithoutHeader(RWElement elm) {
		return elm.getURI().toString().substring(HEADER.length());
	}
	public static final boolean isARegion(String type) {
		return type.equals(RECTANGLE) ||
			type.equals(MARKER) ||
			type.equals(POLYGON) ||
			type.equals(MEMOPAD) ||
			type.equals(BOOKMARK) ||
			type.equals(LINE);
	}
	public static final boolean isAnIDAT(String type) {
		return type.equals(FIRST_IDAT) ||
			type.equals(SECOND_IDAT) ||
			type.equals(THIRD_IDAT);
	}
	
	public static boolean isATextSegmentURI(String uri) {
		return uri.startsWith(HEADER + TEXT_SEGMENT);
	}
	public static boolean isATextSegmentFromUsersNote(String uri) {
		return isATextSegmentURI(uri) && uri.contains(SEP2 + USERS_NOTE) && !uri.contains(SEP2 + EXPLANATORY_NOTE);
	}

	public static boolean isATextSegmentFromFirstIDAT(String uri) {
		return isATextSegmentURI(uri) && uri.contains(SEP2 + FIRST_IDAT) && !uri.contains(SEP2 + EXPLANATORY_NOTE);
	}

	public static boolean isATextSegmentFromSecondIDAT(String uri) {
		return isATextSegmentURI(uri) && uri.contains(SEP2 + SECOND_IDAT) && !uri.contains(SEP2 + EXPLANATORY_NOTE);
	}

	public static boolean isATextSegmentFromThirdIDAT(String uri) {
		return isATextSegmentURI(uri) && uri.contains(SEP2 + THIRD_IDAT) && !uri.contains(SEP2 + EXPLANATORY_NOTE);
	}
	
	public static boolean isATextSegmentFromExplanatoryNote(String uri) {
		return isATextSegmentURI(uri) && uri.contains(SEP2 + EXPLANATORY_NOTE);		
	}



	//test
	public static void main(String[] args) {
		System.out.println("Test in URI");
/*		String uri0 = "smart://spread/img003/Susumu?Hayashi/20110408010349/^directory/root/cate/20110204/";
		String uri1 = "smart://connection/Susumu?Hayashi/20110408014048(1)/~segment/Susumu?Hayashi/20110408014025/^usersNote/aaa/Susumu?Hayashi/20110408011340/^DIRECTORY_segment/Susumu?Hayashi/20110408011438/^explanatory/Susumu?Hayashi/20110408011419/^connection/Susumu?Hayashi/20110408011419(1)/~rect/Susumu?Hayashi/20110408011354/^spread/img004/Susumu?Hayashi/20110408011319(4)/^directory/root/cate/20110204/_polygon/Susumu?Hayashi/20110408011400/^spread/img004/Susumu?Hayashi/20110408011319(4)/^directory/root/cate/20110204/";
		String uri2 = "smart://connection/Susumu?Hayashi/20110408011455(1)/~segment/Susumu?Hayashi/20110408011438/^explanatory/Susumu?Hayashi/20110408011419/^connection/Susumu?Hayashi/20110408011419(1)/~rect/Susumu?Hayashi/20110408011354/^spread/img004/Susumu?Hayashi/20110408011319(4)/^directory/root/cate/20110204/_polygon/Susumu?Hayashi/20110408011400/^spread/img004/Susumu?Hayashi/20110408011319(4)/^directory/root/cate/20110204/_segment/Susumu?Hayashi/20110408011452/^firstIdat/Susumu?Hayashi/20110408011319(5)/^spread/img004/Susumu?Hayashi/20110408011319(4)/^directory/root/cate/20110204/";
//		System.out.println(u.toString());
		System.out.println("parse(uri0).toString().equals(uri0): " + parse(uri0).toString().equals(uri0));
		System.out.println("");
		System.out.println("parse(uri1).toString().equals(uri1): " + parse(uri1).toString().equals(uri1));
		System.out.println("");
		System.out.println("parse(uri2).toString().equals(uri2): " + parse(uri2).toString().equals(uri2));
*/
		URIObject uri = new URIObject("rect");
		URIObject uri2 = new URIObject("rect");
		System.out.println(uri2);
	}
	public void setContainer(URIObject uriObj) {
		this.container = uriObj;
	}
}