/* $Id: SearchResultPanelSegmentMode.java 148 2011-05-01 13:25:14Z shayashi $ */
package smart_gs.image_search.normal.swingui;

import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.Spread;
import smart_gs.util.ImageCropper;

// 2011.04.22 shayashi changes: (1) ROW,COLUMN defaults made smaller, (2) query size reflects on label size.
@SuppressWarnings("serial")
public class SearchResultPanelSegmentMode extends AbstractSearchResultPanel{
	
	private int row = 5;
	private int column = 6;
	
	private int width;
	private int height;

	//Horizontal mode corrections
	private int widthCorrectionHmode = 50;
	private int heightCorrectionHmode = 0;
	//20080715 shimizu, 20110422 shayashi
	//Vertical mode corrections
	private int widthCorrectionVmode = 0;
	private int heightCorrectionVmode = 50;
	// general magnification rate
	private double magnification = 0.7;
		
	public SearchResultPanelSegmentMode(SearchResultViewer parent,List<SearchResult> results,Image queryImage) {
		super(parent,results,queryImage);
		this.SIZE_TO_DISPLAY = row * column;
		this.setLayout(new FlowLayout());
		this.nextCount = this.count + 1;
		this.createNextResults(this.count);
		this.showResult(this.nextResults);
		this.createNextResults(nextCount);
	}

	@Override
	protected JLabel createImageLabel(SearchResult result, Image queryImage) {
		Spread spread = result.getSpread();
		Rectangle2D rect = result.getRectangle();
		int width = queryImage.getWidth(null);
		int height = queryImage.getHeight(null);
		
		//parameters to adjust image size by ImageCropper.crop.
		if(TextType.isHorizontal()){
			this.width = width + this.widthCorrectionHmode;
			this.height = height + this.heightCorrectionHmode;
		}else{
			this.width = width + this.widthCorrectionVmode;
			this.height = height + this.heightCorrectionVmode;
		}
		width *= magnification;
		height *= magnification;
		
		Image image = new ImageCropper(spread,rect).crop(width,height);
		
		JLabel label = new JLabel(new ImageIcon(image));
		
		JWindow window = new ResultPopupWindow(result);
		label.addMouseListener(new LabelMouseListener(label,window,spread,rect));
		return label;
	}
}
