/* $Id: SearchResult.java 152 2011-05-03 09:23:21Z ohura $ */
package smart_gs.image_search.logical;

import java.awt.Rectangle;

import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;

public class SearchResult extends Region{
	
	private double score;
	private int rank;
	private int lineIndex;
	private boolean isSelected = false;
	private boolean wasShown = false;
	private boolean isInBacket = false;
	
	public SearchResult(Spread spread,Rectangle rectangle,double score,int rank,int lineIndex){
		super(spread,new RectangleView(rectangle),"","");
//		super(spread,new RectangleView(rectangle), spread.getCurrentSheet());
		this.spread = spread;
		this.score = score;
		this.rank = rank;
		this.lineIndex = lineIndex;
	}
	public void setWasShown(boolean wasShown){
		this.wasShown = wasShown;
	}
	public boolean wasShown(){
		return this.wasShown;
	}
	public Spread getSpread(){
		return this.spread;
	}
	public int getLineIndex(){
		return this.lineIndex;
	}
	public Rectangle getRectangle() {
		return this.view.getRectangle();
	}
	public double getScore() {
		return score;
	}
	public int getRank() {
		return rank;
	}
	public void setSelected(boolean isSelected){
		this.isSelected = isSelected;
	}
	public boolean isSelected(){
		return this.isSelected;
	}
	public GSQuery toQuery(){
		return new GSQuery(this.spread,this.spread.getDscFile(),this.getRectangle(),"","");
	}
	public void setIsInBacket(boolean bool){
		this.isInBacket = bool;
	}
	public boolean isInBacket(){
		return this.isInBacket;
	}
	public void setRectangle(Rectangle rectangle){
		((RectangleView)this.view).setRectangle(rectangle);
	}
}
