/* $Id: SearchQueryAction.java 152 2011-05-03 09:23:21Z ohura $ */
package smart_gs.image_search;

import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import smart_gs.image_search.logical.TextType;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.logical.Spread;


public class SearchQueryAction extends SearchAction{
	
	private GSQuery query;
	
	private ArrayList<ImageSearchFilter> imageSearchFilterList = new ArrayList<ImageSearchFilter>();

	public SearchQueryAction(GSQuery query,List<Spread> spreadsToSearch) {
		super(spreadsToSearch);
		Rectangle rect = query.getRectangle();
		//20080715 shimizu wrote
		if(TextType.isHorizontal()){
		  rect = new Rectangle(rect.x,rect.y+(rect.height/2),rect.width,1);
		}else{
		//co[W
		  rect = new Rectangle(rect.x+(rect.width/2),rect.y,1,rect.height);
		}
		
		if(query.getSpread() == null){
			this.query = new GSQuery(query.getQueryImage(),query.getDSCFile(),rect);
			this.query.setURIs("", "");
		}else{
			this.query = new GSQuery(query.getSpread(),query.getDSCFile(),rect);
			this.query.setURIs("", "");
		}
	}
	
	public void execute(){
		GSSearchEngine searchEngine = GSSearchEngine.getInstance();
		searchEngine.setQuery(query);
		searchEngine.setSearchScope(spreadsToSearch);
		searchEngine.setImageSearchFilterList(imageSearchFilterList);
		searchEngine.execute();
		this.results = searchEngine.getResults();
	}
	
	public void addImageSearchFilter(ImageSearchFilter imageSearchFilter){
		imageSearchFilterList.add(imageSearchFilter);
	}
}
