/* $Id: RectangleView.java 152 2011-05-03 09:23:21Z ohura $ */
package smart_gs.drawing_tool.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import smart_gs.GSConstants;
import smart_gs.logical.URICreator;

public class RectangleView extends View{

	protected Rectangle2D rectangle;
	
	public RectangleView(Rectangle2D rectangle){
		super();
		this.rectangle = rectangle;
		this.defaultColor = Color.blue;
	}
	//kazuhiro kobayashi 2007/10/9
	public RectangleView(Rectangle2D rectangle, boolean isProtected){
		this(rectangle);
		this.isProtected = isProtected;
	}
	public RectangleView(Rectangle2D rectangle,boolean isSelected,boolean isEmphasized, boolean isProtected){
		this(rectangle);
		this.isSelected = isSelected;
		this.isEmphasized = isEmphasized;
		this.isProtected = isProtected;
	}
	@Override
	public boolean contains(Point2D point) {
		return this.rectangle.contains(point);
	}
	
	@Override
	protected void drawShape(Graphics2D g) {
		g.draw(this.rectangle);
	}

	@Override
	public int getType() {
		return View.RECTANGLE;
	}

	@Override
	public void moveBy(Point2D d) {
		double x = this.rectangle.getX();
		double y = this.rectangle.getY();
		double width = this.rectangle.getWidth();
		double height = this.rectangle.getHeight();
		this.rectangle = new Rectangle2D.Double(x+d.getX(),y+d.getY(),width,height);
	}
	
	@Override
	public View enlargedView(double ratio, double gapX, double gapY) {
		double x = this.rectangle.getX();
		double y = this.rectangle.getY();
		double w = this.rectangle.getWidth();
		double h = this.rectangle.getHeight();
		Rectangle2D rect = new Rectangle2D.Double(x*ratio+gapX,y*ratio+gapY,w*ratio,h*ratio);
		return new RectangleView(rect,this.isSelected,this.isEmphasized, this.isProtected);
	}
	public Rectangle2D getRectangle2D() {
		return this.rectangle;
	}
	@Override
	public String getTypeString() {
		return URICreator.RECTANGLE;
	}
	@Override
	public void drawLinkedShape(Graphics2D g) {
		if(this.isSelected){
			this.draw(g);
			return;
		};
		Color oldColor = g.getColor();
		Stroke oldStroke = g.getStroke();
		g.setColor(Color.BLUE);
		g.setStroke(new BasicStroke(5));
		this.drawShape(g);
		g.setColor(oldColor);
		g.setStroke(oldStroke);
	}
	@Override
	public Element createXMLElement(Document document) {
		Element element = document.createElement("view");
		element.setAttribute("type", URICreator.RECTANGLE);
		element.setAttribute("x",this.rectangle.getX()+"");
		element.setAttribute("y",this.rectangle.getY()+"");	
		element.setAttribute("width",this.rectangle.getWidth()+"");
		element.setAttribute("height",this.rectangle.getHeight()+"");
		return element;
	}
	public static View restore(Element elem) {
		double x = new Double(elem.getAttribute("x"));
		double y = new Double(elem.getAttribute("y"));
		double width = new Double(elem.getAttribute("width"));
		double height = new Double(elem.getAttribute("height"));
		//kazuhiro kobayashi 10/9
		boolean isProtected = elem.getAttribute("protection").equals("PROTECTED");
		return new RectangleView(new Rectangle2D.Double(x,y,width,height), isProtected);
	}
	public void setRectangle(Rectangle rectangle) {
		this.rectangle = rectangle;
	}
	
	@Override
	public Point getCenterPoint() {
		return new Point((int)this.rectangle.getCenterX(), (int)this.rectangle.getCenterY());
	}
	@Override
	public String getTypeStringForDisplay() {
		return "Rectangle";
	}
	
}
