/* $Id: EditLineAction.java 155 2011-05-03 10:31:26Z ohura $ */
package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;
import javax.swing.JFrame;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Spread;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.EditLineFrame;

public class EditLineAction implements ActionListener{
	
	private AbstractGSWindow gsWindow;
	private int type;
	private int edit;
	
	private Spread spread;
	
	

	public EditLineAction(AbstractGSWindow gsWindow,int a, int b){
		this.gsWindow = gsWindow;
		this.type = a;
		this.edit = b;
		
	}
	
	
	public void execute(){
		LineSegment line = spread.getLines().get(0);
		if(line == null){
			JOptionPane.showMessageDialog(new JFrame(), "null","error",  JOptionPane.INFORMATION_MESSAGE);
			return;
		}
		if(this.type == 0){
			if(this.edit == 0){
				spread.changeLinesSize(99.5);
			}
			else{
				spread.changeLinesSize(100.5);
			}
		}
		else if(this.edit == 0){
			spread.slideLines(0, -5);
		}
		else if(this.edit == 1){
			spread.slideLines(0, 5);
		}
		else if(this.edit == 2){
			spread.slideLines(5, 0);
		}
		else{
			spread.slideLines(-5, 0);
		}
		
	}
	
	public void actionPerformed(ActionEvent e){
		this.spread = this.gsWindow.getSpread();
		this.execute();
	}
		
	
}
