/* $Id: ChangeImpactAnalysis.java 125 2011-03-09 09:49:51Z ohura $ */
package reasoning_web.logical;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;


public class ChangeImpactAnalysis extends AbstractCIAnalysis{
		
	public ChangeImpactAnalysis(ResourcePointer changeSource) {
		super(changeSource);
	}
	
	
	private void analyze(ResourcePointer pointer,Hashtable<ResourcePointer, Double> table,List<ResourcePointer> stack,int distance) {
		List<ResourcePointer> elements = pointer.getBackwardDependentElements();
		double f = 1.0/Math.log(distance+Math.E);
		double ci = pointer.getElementRank()*f;
		stack.add(pointer);
		for(int i=0;i<elements.size();i++){
			ResourcePointer element = elements.get(i);
			if(!stack.contains(element)){
				if(table.containsKey(element)){     //łɌvZς݂̏ꍇ
					ci +=table.get(element);
				}else{
					this.analyze(element,table,stack,distance+1);
					ci += table.get(element);
				}
			}
		}
		stack.remove(pointer);
		table.put(pointer,ci);	
	}
	
	public void execute(){
		this.table.clear();
		List<ResourcePointer> pointers = this.changeSource.getBackwardDependentElements();
		
		List<ResourcePointer> stack = new ArrayList<ResourcePointer>();
		
		this.table.put(this.changeSource,1.0);
		
		for(int i=0;i<pointers.size();i++){
			if(!this.table.containsKey(pointers.get(i))){
				this.analyze(pointers.get(i),table,stack,1);
			}
		}
		
//		Enumeration<ResourcePointer> enumeration = table.keys();
//		while(enumeration.hasMoreElements()){
//			ResourcePointer pointer = enumeration.nextElement();
//			pointer.setElementRank(table.get(pointer));
//		}
	}
	


}
