/* $Id: WebDavSetting.java 125 2011-03-09 09:49:51Z ohura $ */
package webdav.preference;

import java.awt.BorderLayout;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JLabel;
import java.awt.Rectangle;
import javax.swing.JTextField;
import javax.swing.JButton;

import smart_gs.logical.Preference;
import webdav.WebDavProcessor;

public class WebDavSetting extends JDialog {

	private static final long serialVersionUID = 1L;

	private JPanel jContentPane = null;

	private JTextField serverPath = null;

	private JLabel jLabel = null;

	private JLabel jLabel1 = null;

	private JTextField userName = null;

	private JLabel jLabel2 = null;

	private JPasswordField password = null;

	private JButton jButton = null;

	private JButton jButton1 = null;

	private JDialog myJDialog;
	/**
	 * This is the default constructor
	 */
	public WebDavSetting(Frame frame,boolean modal) {
		super(frame,modal);
		initialize();
		myJDialog = this;
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(414, 206);
		this.setContentPane(getJContentPane());
		this.setTitle("WebDAV Setting");
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jLabel2 = new JLabel();
			jLabel2.setBounds(new Rectangle(25, 90, 85, 20));
			jLabel2.setText("password");
			jLabel1 = new JLabel();
			jLabel1.setBounds(new Rectangle(25, 60, 85, 20));
			jLabel1.setText("user id");
			jLabel = new JLabel();
			jLabel.setBounds(new Rectangle(25, 30, 85, 20));
			jLabel.setText("server path");
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(getServerpth(), null);
			jContentPane.add(jLabel, null);
			jContentPane.add(jLabel1, null);
			jContentPane.add(getUserName(), null);
			jContentPane.add(jLabel2, null);
			jContentPane.add(getPassword(), null);
			jContentPane.add(getJButton(), null);
			jContentPane.add(getJButton1(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes serverpth	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getServerpth() {
		if (serverPath == null) {
			serverPath = new JTextField();
			Preference preference = Preference.getInstance().getInstance();
			if(preference.getWebdavServerPath() == null){
				serverPath.setText("http://");
			}else{
				serverPath.setText(preference.getWebdavServerPath());
			}
			serverPath.setBounds(new Rectangle(115, 30, 280, 22));
		}
		return serverPath;
	}

	/**
	 * This method initializes userName	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getUserName() {
		if (userName == null) {
			userName = new JTextField();
			userName.setBounds(new Rectangle(115, 60, 100, 22));
			Preference preference = Preference.getInstance().getInstance();
			if(preference.getWebdavUserName() != null){
				userName.setText(preference.getWebdavUserName());
			}
		}
		return userName;
	}

	/**
	 * This method initializes password	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JPasswordField getPassword() {
		if (password == null) {
			password = new JPasswordField();
			password.setBounds(new Rectangle(115, 90, 100, 22));
			Preference preference = Preference.getInstance().getInstance();
			if(preference.getWebdavPassword() != null){
				password.setText(preference.getWebdavPassword());
			}

		}
		return password;
	}

	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton() {
		if (jButton == null) {
			jButton = new JButton();
			jButton.setBounds(new Rectangle(67, 126, 80, 30));
			jButton.setText("OK");
			jButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					String serverPathStr = serverPath.getText();
					String userNameStr = userName.getText();
					String passwordStr = new String(password.getPassword());
					Preference preference = Preference.getInstance().getInstance();
					preference.setWebdavServerPath(serverPathStr);
					preference.setWebdavUserName(userNameStr);
					preference.setWebdavPassword(passwordStr);
					preference.save();
					WebDavProcessor webDavProcessor = WebDavProcessor.getInstance(true);
					if(webDavProcessor == null){
						JOptionPane.showMessageDialog(
								new JFrame() , "It failed in login to WebDAV." , "fatal" ,
								JOptionPane.ERROR_MESSAGE
							);
						return;
					}
					myJDialog.setVisible(false);
				}
			});
		}
		return jButton;
	}

	/**
	 * This method initializes jButton1	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton1() {
		if (jButton1 == null) {
			jButton1 = new JButton();
			jButton1.setBounds(new Rectangle(161, 125, 80, 30));
			jButton1.setText("CANCEL");
			jButton1.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					myJDialog.setVisible(false);
				}
			});
		}
		return jButton1;
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
