/* $Id: MoveTreeToolBar.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

import smart_gs.GSConstants;
import smart_gs.logical.Spread;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

@SuppressWarnings("serial")
public class MoveTreeToolBar extends JToolBar implements ActionListener{
	protected JButton prev;
	protected JButton next;
	
	protected int historycounter = 0;
	protected int pathCount = 0;
	
	private AbstractGSWindow parent;
	public MoveTreeToolBar(AbstractGSWindow parent) {
		prev = new JButton(new ImageIcon(GSConstants.ICON_PATH + "prev_page.png"));
		prev.setEnabled(false);
		prev.addActionListener(this);
		prev.setActionCommand("prev");
		prev.setToolTipText("Previous page (Alt + UP)");
		prev.setMnemonic(KeyEvent.VK_UP);
		this.add(prev);

		next = new JButton(new ImageIcon(GSConstants.ICON_PATH + "next_page.png"));
		next.setEnabled(false);
		next.addActionListener(this);
		next.setActionCommand("next");
		next.setToolTipText("Next page (Alt + DOWN)");
		next.setMnemonic(KeyEvent.VK_DOWN);
		this.add(next);

		this.parent = parent;
	}

	public void actionPerformed(ActionEvent e) {
		int count = parent.getSpreadCanvas().imageLabel.count;
		if(e.getActionCommand().equals("next")){
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount + 1);
			if(spread != null){
				WorkspaceWindow.getInstance().setSpread(spread);
				WorkspaceWindow.getInstance().setImageSearch(spread.toString());
				WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.setCount(count);
				WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.showImage();
			}
		}else if(e.getActionCommand().equals("prev")){
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount - 1);
			if(spread != null){
				WorkspaceWindow.getInstance().setSpread(spread);
				WorkspaceWindow.getInstance().setImageSearch(spread.toString());
				WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.setCount(count);
				WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.showImage();
			}
		}
	}
	public void setPathCount(int pathCount){
		this.pathCount = pathCount;
		{
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount + 1);
			if(spread != null){
				next.setEnabled(true);
			}else{
				next.setEnabled(false);
			}
		}
		{
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount - 1);
			if(spread != null){
				prev.setEnabled(true);
			}else{
				prev.setEnabled(false);
			}
		}
	}
}
