/* $Id: HistoryToolBar.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.swingui.toolbar;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalToolTipUI;

import smart_gs.GSConstants;
import smart_gs.logical.Spread;
import smart_gs.swingui.WorkspaceWindow;

@SuppressWarnings("serial")
public class HistoryToolBar extends JToolBar implements ActionListener {
	protected ArrayList<Spread> historyList = new ArrayList<Spread>();

	protected JButton prev;
	protected JButton next;

	protected int historycounter = 0;

	public HistoryToolBar() {
		prev = new JButton(new ImageIcon(GSConstants.ICON_PATH + "prev_history.png")){
		      public JToolTip createToolTip() {
		          MultiLineToolTip tip = new MultiLineToolTip();
		          tip.setComponent(this);
		          return tip;
		        }
		      };
		prev.setEnabled(false);
		prev.addActionListener(this);
		prev.setActionCommand("prev");
		prev.setToolTipText("Move to previous page in history");
		this.add(prev);
		next = new JButton(new ImageIcon(GSConstants.ICON_PATH + "next_history.png")){
		      public JToolTip createToolTip() {
		          MultiLineToolTip tip = new MultiLineToolTip();
		          tip.setComponent(this);
		          return tip;
		        }
		      };
		next.setEnabled(false);
		next.addActionListener(this);
		next.setActionCommand("next");
		next.setToolTipText("Move to next page in history");
		this.add(next);
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand().equals("prev")) {
			historycounter--;
			Spread spread = historyList.get(historycounter);
			WorkspaceWindow.getInstance().setSpread(spread, false);
			WorkspaceWindow.getInstance().setImageSearch(
					spread.toString());
			if (historycounter < 1) {
				prev.setEnabled(false);
				prev.setToolTipText(null);
			} else {
				{
					StringBuffer tipsBuf = new StringBuffer();
					for (int i =( historycounter - 1); i >= 0; i--) {
						Spread spreadTemp = historyList.get(i);
						tipsBuf.append(spreadTemp.getViewName() + "\n");
					}
					prev.setToolTipText(tipsBuf.toString());
				}
			}
			StringBuffer tipsBuf = new StringBuffer();
			for (int i = (historycounter + 1); i < historyList.size(); i++) {
				Spread spreadTemp = historyList.get(i);
				tipsBuf.append(spreadTemp.getViewName() + "\n");
			}
			next.setEnabled(true);
			next.setToolTipText(tipsBuf.toString());
		} else if (e.getActionCommand().equals("next")) {
			historycounter++;
			Spread spread = historyList.get(historycounter);
			WorkspaceWindow.getInstance().setSpread(spread, false);
			WorkspaceWindow.getInstance().setImageSearch(
					spread.toString());
			if (historyList.size() - 1 <= historycounter) {
				next.setEnabled(false);
				next.setToolTipText(null);
			} else {
				StringBuffer tipsBuf = new StringBuffer();
				for (int i = (historycounter + 1); i < historyList.size(); i++) {
					Spread spreadTemp = historyList.get(i);
					tipsBuf.append(spreadTemp.getViewName() + "\n");
				}
				next.setToolTipText(tipsBuf.toString());
			}
			if (historycounter >= 1) {
				StringBuffer tipsBuf = new StringBuffer();
				for (int i =( historycounter - 1); i >= 0; i--) {
					Spread spreadTemp = historyList.get(i);
					tipsBuf.append(spreadTemp.getViewName() + "\n");
				}
				prev.setEnabled(true);
				prev.setToolTipText(tipsBuf.toString());
			}
		}
	}

	public void addHistory(Spread spread) {
		if (historycounter != historyList.size() - 1) {
			for (int i = historycounter; i < historyList.size(); i++) {
				historyList.remove((historycounter + 1));
			}
		}
		historyList.add(spread);
		historycounter = historyList.size() - 1;
		if (historycounter >= 1) {
			StringBuffer tipsBuf = new StringBuffer();
			for (int i =( historycounter - 1); i >= 0; i--) {
				Spread spreadTemp = historyList.get(i);
				tipsBuf.append(spreadTemp.getViewName() + "\n");
			}
			prev.setEnabled(true);
			prev.setToolTipText(tipsBuf.toString());
		}
		next.setEnabled(false);
		next.setToolTipText(null);
	}

	class MultiLineToolTip extends JToolTip {
		public MultiLineToolTip() {
			setUI(new MultiLineToolTipUI());
		}
	}

	class MultiLineToolTipUI extends MetalToolTipUI {
		private String[] strs;

		private int maxWidth = 0;

		public void paint(Graphics g, JComponent c) {
			FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(
					g.getFont());
			Dimension size = c.getSize();
			g.setColor(c.getBackground());
			g.fillRect(0, 0, size.width, size.height);
			g.setColor(c.getForeground());
			if (strs != null) {
				for (int i = 0; i < strs.length; i++) {
					g.drawString(strs[i], 3, (metrics.getHeight()) * (i + 1));
				}
			}
		}

		public Dimension getPreferredSize(JComponent c) {
			FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(
					c.getFont());
			String tipText = ((JToolTip) c).getTipText();
			if (tipText == null) {
				tipText = "";
			}
			BufferedReader br = new BufferedReader(new StringReader(tipText));
			String line;
			int maxWidth = 0;
			Vector v = new Vector();
			try {
				while ((line = br.readLine()) != null) {
					int width = SwingUtilities
							.computeStringWidth(metrics, line);
					maxWidth = (maxWidth < width) ? width : maxWidth;
					v.addElement(line);
				}
			} catch (IOException ex) {
				ex.printStackTrace();
			}
			int lines = v.size();
			if (lines < 1) {
				strs = null;
				lines = 1;
			} else {
				strs = new String[lines];
				int i = 0;
				for (Enumeration e = v.elements(); e.hasMoreElements(); i++) {
					strs[i] = (String) e.nextElement();
				}
			}
			int height = metrics.getHeight() * lines;
			this.maxWidth = maxWidth;
			return new Dimension(maxWidth + 6, height + 4);
		}
	}

}
