/* $Id: WorkspaceWindow.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.swingui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import smart_gs.GSConstants;
import smart_gs.connection.ConnectionCreator;
import smart_gs.current_text_search.SearchDialogManager;
import smart_gs.dictionary.DictionaryXML;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.logical.Preference;
import smart_gs.logical.UsersNoteTree;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadSelectionListManager;
import smart_gs.logical.SpreadTree;
import smart_gs.menu.export.ExportDialog;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.GlobalViewPanel;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.smleditor.swingui.GSKeyEventPost;
import smart_gs.smleditor.swingui.GSTabbedPane;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.HistoryToolBar;
import smart_gs.swingui.toolbar.MoveTreeToolBar;
import smart_gs.swingui.toolbar.action.GSFileFilter;
import smart_gs.util.GsXMLSaver;
import smart_gs.util.LinkCounter;
import sml_editor.swingui.EditorTextPane;
import webdav.WebDavDownLoadEvent;
import webdav.WebDavListenerAction;
import webdav.WebDavProcessor;

import com.hexidec.ekit.GSHTMLEditorSearchActionListner;

@SuppressWarnings("serial")
public class WorkspaceWindow extends AbstractGSWindow implements GSEditorFrame,
		Serializable {

	private static WorkspaceWindow singleton = new WorkspaceWindow();

	private JPanel mainPanel;
	private JTabbedPane leftPanel;
	private SpreadTreePanel spreadTreePanel;
	private JPanel textDocumentPanel;
	private NorthPanel northPanel;
	private JLabel textDocumentStatusBar;
	private JLabel textDocumentStatusBar2;

	
	private GSKeyEventPost gsKeyEventPost;
	
	// kazuhiro kobayashi 10/9
	private File currentFile;
	
	//2008/9/6 North Grid
	//XVtO
	private static boolean updated = false;
	// 2009/01/23
	// Ō̃Z[u
	// 0 = [J
	// 1 = WebDav
	private static int lastsave = 0;
	
	// 2009/01/23
	private WebDavDownLoadEvent webDavDownLoadEvent;
	
	public static WorkspaceWindow getInstance() {
		return singleton;
	}

	public WorkspaceWindow() {
		super("SMART-GS");
		
		Preference.getInstance().getInstance().load();
		// 2009/02/04 add Northgrid
		{
			String dscFolderPath = Preference.getInstance().getInstance().getDscFolderPath();
			File dscFolder = new File(dscFolderPath);
			if(!dscFolder.exists()){
				dscFolder.mkdirs();
			}
			String imageFolderPath = Preference.getInstance().getInstance().getImageFolderPath();
			File imageFolder = new File(imageFolderPath);
			if(!imageFolder.exists()){
				imageFolder.mkdirs();
			}
			File tempDir = new File(GSConstants.TEMP_PATH);
			tempDir.mkdirs();
		}
		this.enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		this.mainPanel = new JPanel(new BorderLayout());
		this.spreadTreePanel = new SpreadTreePanel();
		this.leftPanel = new JTabbedPane();
		this.leftPanel.addTab("Images", this.spreadTreePanel);
		// shimizu 09/23;
		this.leftPanel.addTab("Notes", new UsersNotePanel());
		this.getContentPane().setLayout(new BorderLayout());

		this.northPanel = new NorthPanel(this);
		this.getContentPane().add(northPanel, BorderLayout.NORTH);

		this.textDocumentPanel = new JPanel(new BorderLayout());
		this.tabbedPane = new WorkspaceTabbedPane();
		this.textDocumentPanel.add(this.tabbedPane, BorderLayout.CENTER);

		JSplitPane mainSplitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
				this.mainPanel, this.textDocumentPanel);

		mainSplitPane.setDividerLocation(500);
		mainSplitPane.setOneTouchExpandable(true);
		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
				this.leftPanel, mainSplitPane);
		splitPane.setOneTouchExpandable(true);

		this.getContentPane().add(splitPane, BorderLayout.CENTER);
		this.setSize(1000, 700);
		
//		2007/11/27 kazuhiro kobayashi
		if(!Preference.getInstance().getInstance().getDefaultGsFilePath().equals("")){
			File defaultGsFile = new File(Preference.getInstance().getInstance().getDefaultGsFilePath());
			this.backup(defaultGsFile);
			this.restore(defaultGsFile);
			this.autosave(defaultGsFile);
		}
		
		KeyboardFocusManager m = KeyboardFocusManager.getCurrentKeyboardFocusManager();
		gsKeyEventPost = new GSKeyEventPost();
		m.addKeyEventPostProcessor(gsKeyEventPost);

	}

	public void save() {
		this.tabbedPane.save();
	}
	public void setSpread(Spread spread) {
		this.setSpread(spread,true);
	}

	public void setSpread(Spread spread,boolean history) {
		this.save();
		super.setSpread(spread);
		this.updateGUI(spread);
		setStatusBar2(spread.getURI());
		this.tabbedPane.setCaret(0);
		if(history){
			HistoryToolBar historyToolBar = this.northPanel.getHistoryToolBar();
			historyToolBar.addHistory(spread);
		}
		updateMoveToolBar();
	}

	public void updateMoveToolBar(){
		MoveTreeToolBar moveTreeToolBar = this.northPanel.getMoveTreeToolBar();
		if(this.tabbedPane.getSpread() != null){
			moveTreeToolBar.setPathCount(this.tabbedPane.getSpread().getPageViewIndex());
		}
	}
	
	public void setImageSearch(String q){
		spreadTreePanel.search(q);
	}
	
	public Spread getSpreadInTree(int row){
		return spreadTreePanel.getSpreadInTree(row);
	}

	public void close(){
		super.close();
		this.textDocumentPanel.removeAll();
		this.validate();
	}
	public void updateGUI(Spread spread) {
		this.textDocumentPanel.removeAll();
		Component mainPanel = ((WorkspaceTabbedPane) tabbedPane).getMainPanel();
		this.mainPanel.removeAll();
		this.mainPanel.add(mainPanel);
		this.textDocumentPanel.add(this.tabbedPane);
		
		textDocumentStatusBar = new JLabel("");
		textDocumentStatusBar2 = new JLabel("");
		JPanel jPanel = new JPanel(new BorderLayout());;
		jPanel.add(textDocumentStatusBar,BorderLayout.PAGE_START);
		jPanel.add(textDocumentStatusBar2,BorderLayout.PAGE_END);
		this.textDocumentPanel.add(jPanel, BorderLayout.SOUTH);
		this.validate();
		
		if(ConnectionCreator.isSourceSet()){
			setStatusBar(ConnectionCreator.getSource().getURI());
		}
	}

	@Override
	public GSTabbedPane createTabbedPane(Spread spread) {
		return new WorkspaceTabbedPane(this, spread);
	}

	public SpreadCanvas getSpreadCanvas() {
		return ((WorkspaceTabbedPane) this.tabbedPane).getSpreadCanvas();
	}

	public static void main(String[] args) {
		WorkspaceWindow.getInstance().setVisible(true);
	}

	public void setEditorToolBar(JToolBar toolbar) {

	}

	public void setEditorTextPane(EditorTextPane textPane) {
		textPane.setSearchAction(new GSHTMLEditorSearchActionListner(){
			public void actionPerformed() {
				SearchDialogManager.setGSEditorToolBar(WorkspaceWindow.getInstance().getGSEditorToolBar());
				SearchDialogManager.visible();				
			}
		});
		this.northPanel.setEditorTextPane(textPane);
	}

	public 	GSEditorToolBar getGSEditorToolBar(){
		return this.northPanel.getGSEditorToolBar();
	}

	public Spread getSpread() {
		return ((WorkspaceTabbedPane) this.tabbedPane).getSpread();
	}

	public Frame getFrame() {
		return this;
	}

	public void restore(File file) {
		// kazuhiro kobayashi 10/9
		this.currentFile = file;

		DocumentBuilder builder;
		Document document;
		try {
			builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			if(file.getName().endsWith(".gsx")) {
				ZipFile gsxFile = new ZipFile(file);
				ZipEntry gsxSpread = gsxFile.getEntry("spread.xml");
				document = builder.parse(gsxFile.getInputStream(gsxSpread));
			} else {
				document = builder.parse(file);
			}
			Element rootElement = document.getDocumentElement();
			String counterValue = rootElement.getAttribute("counter");
			if(counterValue != null){
				try{
					LinkCounter.setID(Integer.parseInt(counterValue));
				}catch(NumberFormatException e){}
			}
			this.setTitle(file.getName() + " - SMART-GS");

			GS_RWRepository.getInstance().initialize();
			Element spreadElement = (Element) rootElement.getElementsByTagName(
					"spreadTree").item(0);
			SpreadTree.getInstance().restore(spreadElement);
			// 20070926 shimizu wrote;
			// 2011.01.03 shayashi changed@for upper-compatibility
			Element usersNoteElement = (Element) rootElement
					.getElementsByTagName("usersNoteTree").item(0);
			boolean old_version = false;
			if (usersNoteElement == null) {
				old_version = true;
				usersNoteElement = (Element) rootElement
					.getElementsByTagName("presentationTree").item(0);};
			// 20070926 shimizu wrote;
			UsersNoteTree.getInstance().clear();
			if ( old_version == false ) {
				UsersNoteTree.getInstance().restore(usersNoteElement);
			} else {
				UsersNoteTree.getInstance().restorePresentations(usersNoteElement);
			}
			Element rwElement = (Element) rootElement.getElementsByTagName(
					"reasoning_web").item(0);
			GS_RWRepository.getInstance().restore(rwElement);
			Element sslists = (Element) rootElement.getElementsByTagName(
					"spreadSelectionLists").item(0);
			if (sslists != null) SpreadSelectionListManager.getInstance().restore(sslists);
			//2009/04/22 North Grid
			if( GS_RWRepository.getInstance().getBackgroundFilePath() != null &&
					GS_RWRepository.getInstance().getBackgroundFilePath().length() > 0 ){
				GlobalViewPanel.getInstance().setBackground(new File(GS_RWRepository.getInstance().getBackgroundFilePath()));
			} 
			setUpdated(false);
			DictionaryXML.setWarning(false);
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		this.tabbedPane.clear();
		this.tabbedPane.validate();
		this.tabbedPane.repaint();
		this.validate();
	}

	//2009/01/23 North Grid
	public boolean saveAll() {
		return saveAll(null);
	}
	public boolean saveAll(File file) {
		this.tabbedPane.save();
		try {
			Document document = DocumentBuilderFactory.newInstance()
					.newDocumentBuilder().newDocument();
			Element rootElement = document.createElement("rootElement");
			rootElement.setAttribute("counter", String.valueOf(LinkCounter.intValue()));
			document.appendChild(rootElement);
			SpreadTree.getInstance().save(document, rootElement);
			// 20080926 shimizu wrote;
			UsersNoteTree.getInstance().save(document, rootElement);
			GS_RWRepository.getInstance().save(document, rootElement);
			// 20101031 shayashi added
			SpreadSelectionListManager.getInstance().save(document, rootElement);
			
			if(file == null){
				file = this.currentFile;
				// 2007/10/7 kazuhiro kobayashi
				String currentDirectory = Preference.getInstance().getInstance()
						.getGsFolderPath();
				File directory = new File(currentDirectory);
				JFileChooser chooser = new JFileChooser(directory);
				// 2007/10/9 kazuhiro kobayahsi
				if (this.currentFile != null) {
					chooser.setSelectedFile(this.currentFile);
				}
				//
				chooser.setFileFilter(new GSFileFilter());
				int input = chooser.showSaveDialog(WorkspaceWindow.getInstance());
				if (input == JFileChooser.CANCEL_OPTION) {
					return false;
				}
				file = chooser.getSelectedFile();
			}
			String path = file.getAbsolutePath();
//			if (!path.endsWith(".gs")) {
//				path += ".gs";
//			}
			//2007/12/3 kazuhiro kobayshi
			new GsXMLSaver(document, path).save();
			
			//2008/9/6 North Grid
			setUpdated(false);
			return true;
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
			return false;
		}
	}

	public void autosave(File file) {
		int autoSaveInterval = 10; // minutes
		Timer timer;
		
		timer = new Timer(1000 * 60 * autoSaveInterval, new AutosaveAction(file));
		timer.start();
	}

	public void exit() {
		// 2007/10/23 kazuhiro kobayashi
		int input ;

		//2008/9/5 North Grid
		//XVɊmF_CAO\dg݂ǉ
		boolean notcofirm = false;
		if( isUpdated() ){
			String filename = null;
			if(lastsave == 0){
				if(this.currentFile != null){
					filename = this.currentFile.getName();
				}
			}else{
				WebDavDownLoadEvent webDavDownLoadEvent = this.getWebDavDownLoadEvent();
				if(webDavDownLoadEvent != null){
					filename = webDavDownLoadEvent.getDownloaname();
				}
			}
			input = JOptionPane.showConfirmDialog(this, "\"" 
					+ (filename == null ? "new file" :  filename )
					+ "\"   Save this file?" );

			if (input == JOptionPane.OK_OPTION) {
				if(this.getLastsave() == 0){
					if( this.saveAll() == false ) return;
				}else{
					WebDavListenerAction webDavListenerAction = new WebDavListenerAction();
					webDavListenerAction.save();
				}
			} else if (input == JOptionPane.NO_OPTION) {

			} else if (input == JOptionPane.CANCEL_OPTION) {
				return;
			}
			//2008/9/5 North Grid
			//ۑ̊mF_CAO͕\Ȃ悤C
			notcofirm = true;
		}
		if( notcofirm == false ){
			input = JOptionPane.showConfirmDialog(this, "Exit SMART-GS?");
			if (input != JOptionPane.OK_OPTION) {
				return;
			}
		}
		Preference.getInstance().getInstance().save();
		//20081031 North Grid Removed
		//SpreadTree.getInstance().saveLine();
		this.tabbedPane.save();
		unlock();
		System.exit(0);
	}
	public void unlock(){
		WebDavDownLoadEvent oldWebDavDownLoadEvent = getWebDavDownLoadEvent();
		if(oldWebDavDownLoadEvent != null){
			String unlockpath = oldWebDavDownLoadEvent.getDownloadpath();
			String unlockname = oldWebDavDownLoadEvent.getDownloaname();
			String locktoken = oldWebDavDownLoadEvent.getLockToken();
			WebDavProcessor webDavProcessor = WebDavProcessor.getInstance();
			if(webDavProcessor == null){
            	JOptionPane.showMessageDialog(
						new JFrame() , "It failed in login WebDav." , "fatal" ,
						JOptionPane.ERROR_MESSAGE
					);
            	return;
			}
			try {
				webDavProcessor.unlock(unlockpath, unlockname, locktoken);
			} catch (IOException e1) {
				// TODO ꂽ catch ubN
				e1.printStackTrace();
			}
		}
		File tempDir = new File(GSConstants.TEMP_PATH);
		tempDir.delete();
		setWebDavDownLoadEvent(null);
	}
	
	
	public void export() {
		if(this.tabbedPane.isAvailable()){
			this.tabbedPane.save();
		}
		JDialog frame = new ExportDialog(this.currentFile);	
		frame.setVisible(true);
	}

	@Override
	protected void processWindowEvent(WindowEvent e) {
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			this.exit();
		}
	}
	public void tabbedPaneSave(){
		synchronized (tabbedPane) {
			this.tabbedPane.save();
		}
	}
	
	public boolean isAlt() {
		return gsKeyEventPost.isAlt();
	}
	public boolean isCtrl() {
		return gsKeyEventPost.isCtrl();
	}
	public boolean isShift() {
		return gsKeyEventPost.isShift();
	}
	public void setStatusBar(String statusmessage){
		textDocumentStatusBar.setForeground(Color.RED);
		textDocumentStatusBar.setText("source : " + statusmessage);
	}
	public void setStatusBar2(String statusmessage){
		textDocumentStatusBar2.setText(statusmessage);
	}
	public boolean isTabbedPaneAvailable(){
		return this.tabbedPane.isAvailable();
	}
	public GSTabbedPane getTabbedPane(){
		return this.tabbedPane;
	}

	public void processEvent(AWTEvent e) {
		super.processEvent(e);
		// ANeBuɂȂ
		if(e.getID() == WindowEvent.WINDOW_ACTIVATED){
			// EBhE̐ݒ
			SearchDialogManager.setGSEditorToolBar(getGSEditorToolBar());
			if(this.tabbedPane != null){
				String key = tabbedPane.getURI();
				if(key == null){
					return;
				}
	        	GSTabbedPane newTabbedPane = GSTabbedPaneManager.getGSTabbedPane(key);
	        	if(newTabbedPane != null){
	        		String windowid = GSTabbedPaneManager.getWindowsID(key);
	        		if(windowid == null){
	        			return;
	        		}
	        		if(windowid.equals(key)){
	        			return;
	        		}
	        		newTabbedPane.save();
		        	String fstidatSource = newTabbedPane.getFirstIDATSource();
		        	this.tabbedPane.updateFirstIDAT(fstidatSource);

		        	String secondSource = newTabbedPane.getSecondIDATSource();
		        	this.tabbedPane.updateSecondIDAT(secondSource);

		        	String thirdidatSource = newTabbedPane.getThirdIDATSource();
		        	this.tabbedPane.updateThirdIDAT(thirdidatSource);

		        	
		        	this.tabbedPane.updateText();
		        	this.tabbedPane.save();
		        	GSTabbedPaneManager.removeGSTabbedPane(key);
	        	}
			}
		}else if(e.getID() == WindowEvent.WINDOW_DEACTIVATED){
			if(this.tabbedPane != null){
		       	this.tabbedPane.save();
		       	String key = tabbedPane.getURI();
	        	GSTabbedPaneManager.setGSTabbedPane(key,key,tabbedPane);
			}
		}else if(e.getID() == WindowEvent.WINDOW_CLOSED){
			if(this.tabbedPane != null){
				String key = tabbedPane.getURI();
				if(key == null){
					return;
				}			
				GSTabbedPaneManager.close(key);
			}
		}
	}

	//2008/9/6 North Grid
	//XVtO
	public static boolean isUpdated() {
		return updated;
	}

	public static void setUpdated(boolean updated) {
		WorkspaceWindow.updated = updated;
//		System.out.println("debug: updated: " + updated);
	}

	public File getCurrentFile() {
		return currentFile;
	}

	// 2009/01/23 North Grid
	public WebDavDownLoadEvent getWebDavDownLoadEvent() {
		return webDavDownLoadEvent;
	}

	public void setWebDavDownLoadEvent(WebDavDownLoadEvent webDavDownLoadEvent) {
		this.webDavDownLoadEvent = webDavDownLoadEvent;
	}

	public int getLastsave() {
		return lastsave;
	}
	public void setLastsave(int lastsave) {
		WorkspaceWindow.lastsave = lastsave;
		if(lastsave == 1){
			this.currentFile = null;
		}
	}

	public void backup(File file) {
		try {
			String backupFileName = file.getPath() + ".bak";
			FileUtils.copyFile(file, new File(backupFileName));			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
