/* $Id: GSTextEditor.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.smleditor.swingui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

import smart_gs.logical.SmartDocument;
import smart_gs.swingui.ButtonFrame;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.EditorFrame;

@SuppressWarnings("serial")
public class GSTextEditor extends ButtonFrame implements EditorFrame{
	
	private SmartDocument document;
	
//	private GSTabbedPane tabbedPane;
	private JToolBar toolBar;
	private GSEditorTextPane textPane;

	public GSTextEditor(SmartDocument document){
		super(document.getSource());
		this.document = document;
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
//		this.tabbedPane = new GSTabbedPane(document,this);
		
		JPanel toolBarPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		
//		GSEditorTextPane textPane = this.tabbedPane.getTextPane();
		this.toolBar = new GSEditorToolBar(textPane);
		String xml = this.document.getSource();
		String source = null;
		if(xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")){
			source = xml.substring("<xml><html>".length(),xml.length() - "</html><xml>".length());
		}
		this.textPane = new GSEditorTextPane(this.document,source,GSEditorTextPane.BASIC);
		textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(textPane));
		textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(textPane));
		textPane.getGSHTMLEditorTextPane().setCaretPosition(0);
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		toolBarPanel.add(this.toolBar);
		this.getContentPane().add(toolBarPanel,BorderLayout.NORTH);
		this.getContentPane().add(this.textPane,BorderLayout.CENTER);
		
		this.setSize(400,400);
		this.validate();
	}
	//2007/10/30 kazuhiro kobayashi
	public GSTextEditor(SmartDocument document, String name){
		super(document.getSource(), name);
		this.document = document;
		String xml = this.document.getSource();
		String source = null;
		if(xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")){
			source = xml.substring("<xml><html>".length(),xml.length() - "</html><xml>".length());
		}
		this.textPane = new GSEditorTextPane(this.document,source,GSEditorTextPane.BASIC);
		textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(textPane));
		textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(textPane));
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
//		this.tabbedPane = new GSTabbedPane(document,this);
		
		JPanel toolBarPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		
	//	GSEditorTextPane textPane = this.tabbedPane.getTextPane();
		this.toolBar = new GSEditorToolBar(textPane);
		toolBarPanel.add(this.toolBar);
		
		this.getContentPane().add(toolBarPanel,BorderLayout.NORTH);
		this.getContentPane().add(this.textPane,BorderLayout.CENTER);
		
		this.setSize(800,600);
		this.validate();
	}
	@Override
	public void ok() {
		String source = textPane.getSource("body");
		this.document.setSource("<xml><html>" + source + "</html></xml>");
		this.dispose();
	}
	@Override
	public void cancel() {
		this.dispose();
	}
	public void setEditorToolBar(JToolBar toolbar) {
		
	}
	//20071215 shimizu wrote
	public void emphasize(String id) {
		// 20080919 hashimoto wrote
		this.textPane.emphasize(id);
//		this.textPane.getGSHTMLEditorTextPane().emphasize(id);
	}
	//20080901 hashimoto wrote
	public GSEditorTextPane getGSEditorTextPane() {
		return this.textPane;
	}
	
}
