/* $Id: ResourcePointerView.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.reasoning_web.swingui.view;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import reasoning_web.logical.ResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWElement;

/**
 * @author kazuaki kobayashi
 * 
 * 
 */
public class ResourcePointerView extends RectangleView {

	private ResourcePointer element;

	private int X = 300;
	private int Y = 300;
	// 2007/10/24 kazuhiro kobayashi
	private int WIDTH = 15;
	private int HEIGHT = 15;

	private String uri;

	private String name = "";

	/**
	 * @param sourceView
	 */
	public ResourcePointerView(ResourcePointer element) {
		this.element = element;
		this.X = 300;
		this.Y = 300;
		// this.X = this.hashCode() % 400;
		// this.Y = this.hashCode() % 400;
		this.uri = ((GS_RWElement) this.getElement().getElement()).getURI();	
//		Debug shayashi 2011.02.17
		System.out.print("OKOK: " + this.uri + "\n");	
		// 2007/10/24 kazuhiro kobayashi
		// this.WIDTH += this.uri.length() + 5;
		//
		super.rect = new Rectangle2D.Double(X, Y, WIDTH, HEIGHT);
		// this.name = this.element.getNote().getName();
	}

	@Override
	public void drawShape(Graphics2D g) {
		super.drawShape(g);
		int x = (int) this.rect.getMinX() + 20; // +5+1͔AlɈӖ͂Ȃ
		int y = (int) super.rect.getCenterY() + 1;
		// g.drawString(this.element.getElementRank()+"",x,y);
		// 2007/11/23 kazuhiro kobayashi
		this.name = this.element.getName();
		if (!this.name.equals("")) {
			g.drawString(this.name, x, y);
		} else {
			g.drawString(this.uri, x, y);
		}

		// g.drawString(this.element.getNote().getName(), x, y);
	}

	public String toString() {
		return "" + element;
	}

	public Rectangle2D getShape() {
		return super.rect;
	}

	public ResourcePointer getElement() {
		return this.element;
	}

	// 2007/10/22 kazuhiro kobayahsi
	public Rectangle2D getRectangle() {
		return this.rect;
	}

	public void setRectangle(double x, double y, double w, double h) {
		super.rect = new Rectangle2D.Double(x, y, w, h);
	}

	public void setRectangle(double x, double y) {
		super.rect = new Rectangle2D.Double(x, y, WIDTH, HEIGHT);
	}

}
