/* $Id: LocalViewFrame.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Hashtable;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

import smart_gs.logical.SmartDocument;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.swingui.ButtonFrame;



@SuppressWarnings("serial")
//2007/11/2 kazuhiro kobayashi
public class LocalViewFrame extends ButtonFrame{
	
	private Hashtable<GS_RWElement,GSExplanatoryNote> elements;
	private JPanel localViewPanel;
	
	//
	private ArrayList<GSEditorTextPane> textPanes = new ArrayList<GSEditorTextPane>();
	private ArrayList<SmartDocument> documents = new ArrayList<SmartDocument>();
	private ArrayList<JTextField>  nameFields = new ArrayList<JTextField>();
	
	public static final int HEIGHT = 600;
	public static final int WIDTH = 1030;
	
	public LocalViewFrame(Hashtable<GS_RWElement,GSExplanatoryNote> elements){
		super("","Local View");
		this.elements = elements;
		//2007/11/2 kazuhiro kobayashi
//		this.getContentPane().setLayout(new BorderLayout());
		this.localViewPanel = new LocalViewPanel(this.elements, this);
		//
		this.localViewPanel.setMaximumSize(new Dimension(WIDTH, this.elements.size()*HEIGHT));
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.getVerticalScrollBar().setUnitIncrement(25);
		scrollPane.setViewportView(this.localViewPanel);
		//
		this.getContentPane().add(scrollPane,BorderLayout.CENTER);
		this.setSize(WIDTH,this.setFrameSize());
	
		this.validate();
	}
	//2007/11/22 kazuhiro kobayashi
	private int setFrameSize(){
		if(800 > this.elements.size()*HEIGHT){
			return this.elements.size()*HEIGHT;
		}
		else{
			return 800;
		}
		
	}
	
	//2007/11/12 kazuhiro kobayashi
	public void ok(){
		this.notifyTextPane();
		this.dispose();
	}
	public void cancel(){
		this.dispose();
	}
	public void addTextPane(GSEditorTextPane textPane,JTextField nameField){
		this.textPanes.add(textPane);
		this.documents.add(textPane.getSmartDocument());
		this.nameFields.add(nameField);
	}
	public void notifyTextPane(){
		for(int i = 0; i < this.textPanes.size(); i++){
			GSEditorTextPane textPane = this.textPanes.get(i);
			JTextField nameField = this.nameFields.get(i);
			SmartDocument document = this.documents.get(i);
			document.setName(nameField.getText());
			document.setSource("<xml><html>" + textPane.getSource("body") + "</html></xml>");
//			document.setSource(textPane.getGSHTMLEditorTextPane().getController().document2Source());
//			textPane.setSourceMode(textPane.getGSHTMLEditorTextPane().getController().document2Source());
		}
	}
}
