/* $Id: GSResourcePointer.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.reasoning_web.logical;

import java.util.Hashtable;

import javax.swing.JPanel;
import javax.swing.JDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.connection.ConnectionCreator;
import smart_gs.logical.URISolver;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.GlobalViewPanel;
import smart_gs.reasoning_web.swingui.view.ResourcePointerView;
import smart_gs.reasoning_web.swingui.view.View;

public class GSResourcePointer extends ResourcePointer {

	protected View view;

	protected GSResourcePointer(GS_RWElement element) {
		super(element);
		this.view = new ResourcePointerView(this);
	}

	public View getView() {
		return this.view;
	}

	//20080521 shimizu localviewŃNʂ邽߁AꕔCB;
	public Hashtable<GS_RWElement, GSExplanatoryNote> getLocalViewInfo() {
		Hashtable<GS_RWElement, GSExplanatoryNote> elements = new Hashtable<GS_RWElement, GSExplanatoryNote>();
		for (int i = 0; i < this.connections.size(); i++) {
			Connection connection = this.connections.get(i);
			ExplanatoryNote note = connection.getExplanatoryNote();
			ResourcePointer pointer = connection.getOppositePointer(this);
			note.position = pointer.position;
			elements.put((GS_RWElement) pointer.getElement(),
					(GSExplanatoryNote) note);
		}
		return elements;
	}

	public Element createXMLElement(Document document) {
		Element element = document.createElement("pointer");
		element.setAttribute("uri", ((GS_RWElement) this.element).getURI());
		// 2007/10/22 kazuhiro kobayashi

		element.setAttribute("x", String.valueOf(this.view.getRectangle()
				.getX()));
		element.setAttribute("y", String.valueOf(this.view.getRectangle()
				.getY()));
		element.setAttribute("width", String.valueOf(this.view.getRectangle()
				.getWidth()));
		element.setAttribute("height", String.valueOf(this.view.getRectangle()
				.getHeight()));

		// 2007/10/23
		if (this.name != "") {
			element.setAttribute("name", this.name);
		}

		return element;
	}

	public static GSResourcePointer restore(Element element) {
		String uri = element.getAttribute("uri");
		System.out.println(uri);
		// 2007/10/22 kazuhiro kobayashi
		double x = 300;
		double y = 300;
		//
		String name = "";
//		 ExplanatoryNote note = null;
		if (element.getAttribute("x") != "") {
			x = Double.parseDouble(element.getAttribute("x"));
		}
		if (element.getAttribute("y") != "") {
			y = Double.parseDouble(element.getAttribute("y"));
		}
		if (element.getAttribute("name") != "") {
			name = element.getAttribute("name");
		}
		//
		GS_RWElement resource = URISolver.getResource(uri);
//		Debug shayashi 2011.02.17
		System.out.println(uri + " DEBUG resource " + resource + "\n");
		if (GS_RWRepository.getInstance().isRegistered(resource)) {
			// 2007/10/22 kazuhiro kobayashi
			GSResourcePointer pointer = GS_RWRepository.getInstance()
					.getResourcePointer(resource);
			pointer.view.setRectangle(x, y);
			// 10/23
			pointer.setName(name);
			// pointer.setNote(note);
			//
			return pointer;
		}

		GSResourcePointer pointer = new GSResourcePointer(resource);
		pointer.view.setRectangle(x, y);
		pointer.setName(name);
		return pointer;
	}

	public String getURI() {
		return ((GS_RWElement) this.element).getURI();
	}

}
