/* $Id: SetRWBackgroundFilePathAction.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.menu.action;

import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import smart_gs.logical.Preference;
import smart_gs.logical.filter.ImageFileFilter;
import smart_gs.menu.DirectorySettingWindow;
import smart_gs.menu.action.SetNameCorrespondenceAction.CSVFileFilter;

public class SetRWBackgroundFilePathAction extends SetDirectoryPathAction implements ActionListener{

	public SetRWBackgroundFilePathAction(){
		super();
		this.chooser.setDialogTitle("RW background file");
		chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
		
		chooser.setFileFilter(new ImageFileFilter());
//		chooser.setSelectedFile(new File(getOldPath()));
	}
	@Override
	protected String getOldPath() {
		// TODO Auto-generated method stub
		return Preference.getInstance().getInstance().getRWBackgroundFilePath();
	}

	@Override
	protected void validateNewPath(String newPath) {
		// TODO Auto-generated method stub
		DirectorySettingWindow.getInstance().setRWBackgroundFileField(newPath);
	}
	public class ImageFileFilter extends FileFilter{


		public boolean accept(File pathname) {
			String name = pathname.getAbsolutePath();
			if(name.endsWith("png") || name.endsWith("jpg") || name.endsWith("gif") || name.endsWith("JPG") || name.endsWith("JPEG")||name.endsWith("bmp")){
				return true;
				
			}else if(pathname.isDirectory()){
				return true;
			}
			return false;
		}

		@Override
		public String getDescription() {
			return "png, jpg, gif, JPG, JPEG, bmp";
		}
	}
}
