/* $Id: MarkerChangeDefaultBreadthAction.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.menu.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.swingui.AbstractGSWindow;

public class MarkerChangeDefaultBreadthAction implements ActionListener {

	private AbstractGSWindow window;
	
	public MarkerChangeDefaultBreadthAction(AbstractGSWindow window) {
		this.window = window;
	}
	
	@Override
	public void actionPerformed(ActionEvent arg0) {
		int old_breadth = MarkerView.getDefaultBreadth();
		try {
			String new_breadth = JOptionPane.showInputDialog("Please input a positive integer (not less than 5).", old_breadth);
			while (new_breadth == null || Integer.parseInt(new_breadth) < 5) {
				new_breadth = JOptionPane.showInputDialog("Please input a positive integer greater than 15.", old_breadth);
			}
			MarkerView.setDefaultBreadth(Integer.parseInt(new_breadth));
			ImageLabel.setRectangleVisible(true);
		} catch (NumberFormatException error) {
			JOptionPane.showMessageDialog(window.getRootPane(), "An inappropriate value!");
		}
	}

}
