/* $Id: IDATNamesSetting.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.menu;

import java.awt.Frame;
import java.awt.Rectangle;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

import smart_gs.logical.Preference;
import smart_gs.swingui.IDATNameInGSTabbedPaneManager;

public class IDATNamesSetting extends JDialog {

	private JPanel jContentPane = null;

	private JTextField firstIDATNameField = null;
	private JLabel jLabel1 = null;

	private JTextField secondIDATNameField = null;
	private JLabel jLabel2 = null;
	
	private JTextField thirdIDATNameField = null;
	private JLabel jLabel3 = null;


	private JButton jButton = null;

	private JButton jButton1 = null;

	private JDialog myJDialog;
	/**
	 * This is the default constructor
	 */
	public IDATNamesSetting(Frame frame,boolean modal) {
		super(frame,modal);
		initialize();
		myJDialog = this;
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(414, 206);
		this.setContentPane(getJContentPane());
		this.setTitle("IDAT Name Setting");
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jLabel1 = new JLabel();
			jLabel2 = new JLabel();
			jLabel3 = new JLabel();
			jLabel1.setText("First IDAT");
			jLabel2.setText("Second IDAT");
			jLabel3.setText("Third IDAT");
			jLabel1.setBounds(new Rectangle(25, 30, 85, 20));
			jLabel2.setBounds(new Rectangle(25, 60, 85, 20));
			jLabel3.setBounds(new Rectangle(25, 90, 85, 20));

			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(jLabel1, null);
			jContentPane.add(jLabel2, null);
			jContentPane.add(jLabel3, null);
			jContentPane.add(getFirstIDATNameField(), null);
			jContentPane.add(getSecondIDATNameField(), null);
			jContentPane.add(getThirdIDATNameField(), null);
			jContentPane.add(getJButton(), null);
			jContentPane.add(getJButton1(), null);
		}
		return jContentPane;
	}

	private JTextField getFirstIDATNameField() {
		if (firstIDATNameField == null) {
			firstIDATNameField = new JTextField();
			Preference preference = Preference.getInstance();
			firstIDATNameField.setText(preference.getFirstIDATName());
			firstIDATNameField.setBounds(new Rectangle(115, 30, 280, 22));
		}
		return firstIDATNameField;
	}

	private JTextField getSecondIDATNameField() {
		if (secondIDATNameField == null) {
			secondIDATNameField = new JTextField();
			Preference preference = Preference.getInstance();
			secondIDATNameField.setText(preference.getSecondIDATName());
			secondIDATNameField.setBounds(new Rectangle(115, 60, 280, 22));
		}
		return secondIDATNameField;
	}
	
	private JTextField getThirdIDATNameField() {
		if (thirdIDATNameField == null) {
			thirdIDATNameField = new JTextField();
			Preference preference = Preference.getInstance();
			thirdIDATNameField.setText(preference.getThirdIDATName());
			thirdIDATNameField.setBounds(new Rectangle(115, 90, 280, 22));
		}
		return thirdIDATNameField;
	}

	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton() {
		if (jButton == null) {
			jButton = new JButton();
			jButton.setBounds(new Rectangle(67, 126, 80, 30));
			jButton.setText("OK");
			jButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					String firstIDATNameStr = firstIDATNameField.getText();
					String secondIDATNameStr = secondIDATNameField.getText();
					String thirdIDATNameStr = thirdIDATNameField.getText();

					if (firstIDATNameStr.equals("Image")
							|| secondIDATNameStr.equals("Image")
							|| thirdIDATNameStr.equals("Image")){
						JOptionPane.showMessageDialog(null, "Error: IDAT name \"Image\" is not allowed.");
						return;}
					if (firstIDATNameStr.equals(secondIDATNameStr) && ! secondIDATNameStr.equals("")) {
						JOptionPane.showMessageDialog(null, "Error: first and second IDAT names are identical.");
						return;}
					if (firstIDATNameStr.equals(thirdIDATNameStr) && ! thirdIDATNameStr.equals("")) {
						JOptionPane.showMessageDialog(null, "Error: first and third IDAT names are identical.");
						return;}
					if (secondIDATNameStr.equals(thirdIDATNameStr) && ! thirdIDATNameStr.equals("")) {
						JOptionPane.showMessageDialog(null, "Error: second and third IDAT names are identical.");
						return;}
					
					if (firstIDATNameStr.equals("")) firstIDATNameStr = "Note1";
					if (secondIDATNameStr.equals("")) secondIDATNameStr = "Note2";
					if (thirdIDATNameStr.equals("")) thirdIDATNameStr = "Note3";
					
					Preference preference = Preference.getInstance();
					preference.setFirstIDATName(firstIDATNameStr);
					preference.setSecondIDATName(secondIDATNameStr);
					preference.setThirdIDATName(thirdIDATNameStr);
					preference.save();

		    		IDATNameInGSTabbedPaneManager.updateTabtitles();
					myJDialog.setVisible(false);
				}
			});
		}
		return jButton;
	}

	/**
	 * This method initializes jButton1	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton1() {
		if (jButton1 == null) {
			jButton1 = new JButton();
			jButton1.setBounds(new Rectangle(161, 125, 80, 30));
			jButton1.setText("CANCEL");
			jButton1.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					myJDialog.setVisible(false);
				}
			});
		}
		return jButton1;
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
