/* $Id: TextSegment.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.logical;

import java.awt.BorderLayout;

import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.w3c.dom.Element;

import reasoning_web.logical.NotMarkupException;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.logical.visitor.Visitor;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSWysiwygMouseListener;
import smart_gs.smleditor.swingui.GSWysiwygMouseMiniListener;
import smart_gs.util.StringUtils;

public class TextSegment extends GSResource{
	
	private String tagname;
	private SmartDocument document;

	public TextSegment(String tagname,SmartDocument document,int id) {
		//kobayashi
		super(document.getURI()+"/"+uriExtension());//2011/01/06 kukita
		this.document = document;
		this.setId(id);
//		System.out.println("test: "+id+": "+document.getURI());
//		this.setURI(document.getURI()+"/"+id);
		this.tagname = tagname;
		
		this.extendUriBy(id);
		//2011/01/19 kukita
	}
	TextSegment(String tagname,int id,String uri){
		super(uri);
		this.tagname = tagname;
		this.setId(id);
		
		this.extendUriBy(id);
		//2011/01/19 kukita
	}
	
	public String getTagName(){
		return this.tagname;
	}
	public SmartDocument getDocument(){
		return this.document;
	}
	@Override
	public JPanel createElementViewPanel() throws NoWayToShowException {
		JPanel panel = new JPanel(new BorderLayout());
/*		SmlController controller;
		try {
			controller = new SmlController(this.getDocument().getSource());
		} catch (SAXException e) {
			throw new NoWayToShowException();
		} */
		
		String source = null;
		
		// 20080919 hashimoto wrote
		// LocalViewText(UsersNote)\邽ߏC
		if(this.document instanceof IDAT){
		// Ẽf[^݂Ȃ̂
		// 擾
		try{
			String left = this.document.getSource();
			if(!(left.indexOf("<xml><left><html>") == -1 && left.lastIndexOf("</html></left>") == -1)){
				source = left.substring("<xml><left><html>".length(),left.lastIndexOf("</html></left>"));
			}
		}catch(Exception e){
		}
		}else{
			source = this.document.getSource();
			if(!(source.indexOf("<xml><html>") == -1 && source.lastIndexOf("</html></xml>") == -1)){
				source = source.substring("<xml><html>".length(),source.lastIndexOf("</html></xml>"));
			}
		}
		GSEditorTextPane textPane = new GSEditorTextPane(this.document,source,GSEditorTextPane.BASIC);
		textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseMiniListener(textPane));
		textPane.setMenuMode(true);
		textPane.setSourceMode(false);
		textPane.setEdit(false);
		textPane.updateUI();
		textPane.setAutoscrolls(false);
//		JScrollPane scrollPane = new JScrollPane();
//		textPane.getGSHTMLEditorTextPane().emphasize(this.id+"");
//		scrollPane.setAutoscrolls(false);
		textPane.emphasize(this.id+""); // 20080919 hashimoto wrote
		textPane.getGSHTMLEditorTextPane().updateText();
		
		//textPane.setCaretPosition(300);

//		scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
//		scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		textPane.setFocusable(false);
//		scrollPane.setViewportView(textPane);
		panel.add(textPane,BorderLayout.CENTER);
		return panel;
	}
	

	public void setSmartDocument(SmartDocument document){
		this.document = document;
	}
	
	public static TextSegment restore(Element element){
		String tagname = element.getAttribute("tagname");
		String id = element.getAttribute("id");
		String uri = element.getAttribute("uri");
		return new TextSegment(tagname,new Integer(id),uri);
	}
	
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	@Override
	public boolean equals(Object obj) {
		if(obj == null){
			return false;
		}
		return this.toString().equals(obj.toString());
	}
	
}
