/* $Id: SpreadDirectory.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.logical;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Collections;

import javax.swing.tree.DefaultMutableTreeNode;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.GSConstants;
import smart_gs.logical.visitor.Visitor;

public class SpreadDirectory extends GSResource{
	
	private File imageFolder;	
	private List<GSResource> resources;
	private SpreadDirectory parent;
	
	
	
	public SpreadDirectory(String name,File imageFolder,File textFolder){
		super(GSConstants.URI_HEADER);
		this.name = name;
		this.parent = null;
		this.imageFolder = imageFolder;
		this.resources = new ArrayList<GSResource>();
		//2007/11/20 kazuhiro kobayashi
		this.systemName = name;
		if(this.userName==null){
			this.userName = name;
		}
	}
	public List<GSResource> getResources(){
		return this.resources;
	}
	public SpreadDirectory(SpreadDirectory parent,String name,File file){
		super(parent.getURI()+name+File.separator);
		this.name = name;
		this.parent = parent;
		this.imageFolder = file;

		this.resources = new ArrayList<GSResource>();
		//2007/11/20 kazuhiro kobayashi
		this.systemName = name;
		if(this.userName==null){
			this.userName = name;
		}
	}
	public String getName(){
		return this.name;
	}
	public List<Spread> getSpreads(){
		List<Spread> results = new ArrayList<Spread>();
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof Spread){
				results.add((Spread)resource);
			}else if(resource instanceof SpreadDirectory){
				results.addAll(((SpreadDirectory)resource).getSpreads());
			}
		}
		return results;
	}
	public List<SpreadDirectory> getSpreadDirectorys(){
		List<SpreadDirectory> results = new ArrayList<SpreadDirectory>();
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof SpreadDirectory){
				results.add((SpreadDirectory)resource);
				results.addAll(((SpreadDirectory)resource).getSpreadDirectorys());
			}
		}
		return results;
	}
	public void addResource(GSResource resource){
		this.resources.add(resource);
	}
	public File getFile(){
		return this.imageFolder;
	}
	public String toString(){
		//2007/11/20 kazuhiro kobayshi
		return this.userName;
	}
	public String getPath() {
		String path = "";
		if(this.parent != null){
			path = this.parent.getPath();
		}else{
			return path;
		}
		return path+this.getName()+"/";
	}

	public void restore(Element element) {
		this.resources.clear();
		NodeList nodes = element.getChildNodes();
		for(int i=0;i<nodes.getLength();i++){
			Node node = nodes.item(i);
			if(node.getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)node;
				String tagname = elem.getNodeName();
				/*
				 *@ResourceɂΉB
				 */
				if(tagname.equals("spread")){
					Spread spread = XML2ResourceConverter.getSpread(this, elem);
					SpreadTree.getInstance().addSpread(spread);
					this.addResource(spread);
				}else if(tagname.equals("directory")){
					String name = elem.getAttribute(GSResource.NAME);
					String uri = elem.getAttribute(GSResource.URI);
					String filename = elem.getAttribute("filename");
					SpreadDirectory directory = new SpreadDirectory(this,name,new File(filename));
					SpreadTree.getInstance().addSpreadDirectory(directory);
					this.addResource(directory);
					directory.setURI(uri);
					directory.restore(elem);
				}
			}
		}
	}
	public void setTree(DefaultMutableTreeNode parent){
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof Spread){
				parent.add(new DefaultMutableTreeNode(resource));
			}else if(resource instanceof SpreadDirectory){
				DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(resource);
				parent.add(newNode);
				((SpreadDirectory)resource).setTree(newNode);
				
			}
		}
	}
	
	public void remove(Spread  spread){
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof Spread){
				if(resource.toString().equals(spread.toString())){
					resources.remove(i);
					break;
				}
			}else if(resource instanceof SpreadDirectory){
				((SpreadDirectory)resource).remove(spread);
			}
		}
	}
	public void removeDirectory(SpreadDirectory spreadDirectory){
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof SpreadDirectory){
				if(resource.toString().equals(spreadDirectory.toString())){
					resources.remove(i);
					break;
				}
				((SpreadDirectory)resource).removeDirectory(spreadDirectory);
			}
		}
	}
	public void removeAllChildren(){
		for(int i=0;i<this.resources.size();i++){
			GSResource resource = this.resources.get(i);
			if(resource instanceof Spread){
				resources.remove(i);
			}else if(resource instanceof SpreadDirectory){
				((SpreadDirectory)resource).removeAllChildren();
				resources.remove(i);
			}
		}
	}
	
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	
	public void sort(){
		Collections.sort(resources, new Comparator<GSResource>() {   
			public int compare(GSResource o1, GSResource o2) {
				if((o1 instanceof Spread) && (o2 instanceof Spread)){
					if(((Spread)o1).getPageViewIndex() > ((Spread)o2).getPageViewIndex()){
						return 1;
					}else{
						return -1;
					}
				}
				return 0;
			}
		});   
	}
	
}
