/* $Id: SearchResultPanel.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * 쐬: 2006/06/21
 *
 */
package smart_gs.image_search.normal.swingui;

import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

import smart_gs.image_search.LineImageCropper;
import smart_gs.image_search.logical.SearchResult;

/**
 * @author kazuaki kobayashi
 *
 * 
*/
@SuppressWarnings("serial")

class SearchResultPanel extends AbstractSearchResultPanel{
		
	SearchResultPanel(SearchResultViewer parent,List<SearchResult> results){
		super(parent,results);
		this.setLayout(new GridLayout(SIZE_TO_DISPLAY,1));
		this.createNextResults(this.count);
		this.nextCount = this.count + 1;
		this.showResult(this.nextResults);
		this.createNextResults(nextCount);
	}	
	protected JLabel createImageLabel(SearchResult result){	
		LineImageCropper cropper = new LineImageCropper(result);
		BufferedImage bufImage = cropper.crop();	
		bufImage = (BufferedImage) cropper.fillRelative(bufImage);
		ImageIcon icon = new ImageIcon(bufImage);	
		JLabel label = new JLabel();
		label.setIcon(icon);
		label.addMouseListener(new LabelMouseListener(label,result.getSpread(),result.getRectangle()));
		return label;
	}
}
