/* $Id: BacketFrame.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.image_search.normal.swingui;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JScrollPane;


import smart_gs.image_search.MultiSearchAction;
import smart_gs.image_search.logical.QueryBacket;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.reasoning_web.desktop.logical.ShortCut;
import smart_gs.reasoning_web.desktop.swingui.DesktopWindow;
import smart_gs.swingui.ButtonFrame;
import smart_gs.swingui.CreateShortCutDialog;

import smart_gs.logical.Spread;
import smart_gs.spread_selection.SetScopePanel;;

@SuppressWarnings("serial")
public class BacketFrame extends ButtonFrame{
	
	private BacketPanel backetPanel;
	private List<SearchResult> previousResults;
	
	// 20071109 c -- Oꂽ̃Xgǉ
	private List<SearchResult> removedResults;
	// private int removeSize;
	
	private int previousSize;
	//͈͂̎w
	private SetScopePanel scopePanel;
	
	public BacketFrame(QueryBacket backet){
		this(backet,null,"Query Backet");
	}
	/*
	 * 20071109 c
	 * ʂ̃TCY͕ς̂ň폜
	 */ 
	public BacketFrame(QueryBacket backet,String title, List<SearchResult> results, List<SearchResult> removedResults, int size) {
		this(backet,null,title);
		previousResults = results;
		this.previousSize = size;
		this.setRemovedResults(removedResults);
		// this.removedResults = removedResults;
	}
	
	public BacketFrame(QueryBacket backet,Frame parent, String title) {
		super(parent, title);
		JScrollPane scrollPane = new JScrollPane();
		this.backetPanel = new BacketPanel(this,backet);
		this.okButton.setText("Search");
		
		scrollPane.setViewportView(this.backetPanel);
		
		this.getContentPane().add(scrollPane,BorderLayout.CENTER);
		JButton register = new JButton("Register");
		register.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				register();
			}
		});
		this.getButtonPanel().add(register, 1);
		
		/*
		 * ͈͂̎w
		 */
		this.scopePanel = new SetScopePanel();
		this.getButtonPanel().add(scopePanel);

	}
	
	/* 
	 * 20071109 c
	 * Oꂽ̍XV
	 */
	public void setRemovedResults(List<SearchResult> removedResults) {
	    // this.removeSize = removedResults.size();
	    this.removedResults = removedResults;
	}

	@Override
	public void cancel() {
		this.dispose();
	}
	public void register(){
		QueryBacket backet = this.backetPanel.getBacket();
		/*
		 *  Oƃc
		 */
		CreateShortCutDialog dialog = new CreateShortCutDialog(this);

		dialog.setVisible(true);
		DesktopWindow.getInstance().getRootFolder().add(new ShortCut(backet,dialog.getName(),dialog.getDocument()));
	}
	
	@Override
	public void ok() {
	    /*
	     * 20071109 c
	     * previousResults Oꂽ
	     * 
	     */
	    List<SearchResult> pResults = new ArrayList<SearchResult>();
		//ύX@c
	    for (int i = 0; i < previousResults.size(); i++) {
		if (!removedResults.contains(previousResults.get(i))) {
		    previousResults.get(i).setWasShown(true);
		    pResults.add(previousResults.get(i));
		}
	    }
	    // this.previousSize = pResults.size();
		/*
		 * ͈͂̎w̏ǉ
		 */
	    List<Spread> spreads = this.scopePanel.getSpreadsToSearch();
		QueryBacket backet = this.backetPanel.getBacket();
		System.out.println("spread to search: " + spreads);
//		MultiSearchAction action = new MultiSearchAction(backet,SpreadTree.getInstance().getDSCSpreads());
		MultiSearchAction action = new MultiSearchAction(backet,this.scopePanel.getDSCSpreads(spreads));
		
		if(pResults != null){
			action.setPreviousResults(pResults, this.previousSize);
		}
		action.execute();
		//2007/10/11 kazuhiro kobayashi
		//Ώۂ̃y[W\邽
		new SearchResultViewer(backet,action.getResults(), this.scopePanel.getSelectedPage()).setVisible(true);
		this.dispose();
	}
}
