/* $Id: DefaultState.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.drawing_tool.state;

import java.awt.Graphics;
import java.util.ArrayList;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.WorkspaceWindow;

public class DefaultState implements State{
	
	protected static DefaultState singleton = new DefaultState();
	static{
		singleton.addSetmodeEvent(new DefaultStateEvent());
	}
	
	private Mode mode;
	
	private ArrayList<StateEvent> evnetList = new ArrayList<StateEvent>();
	
	protected DefaultState(){
		this.mode = DefaultDrawingMode.getInstance();
	}
	
	public static DefaultState getInstance(){
		return singleton;
	}
	public void setMode(Mode mode){
		this.mode = mode;
		for(int i=0;i<evnetList.size();i++){
			StateEvent stateEvent = evnetList.get(i);
			stateEvent.setMoveEvent(mode);
		}
	}
	public static void setDefaultState(DefaultState state){
		singleton = state;
		ImageLabel.setState(state);
	}
	public static void restoreDefaultState(){
		singleton = new DefaultState();
		ImageLabel.setState(singleton);
	}
	public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas) {
		this.mode.mouseClicked(e,canvas);
	}

	public void mouseDragged(GSMouseEvent e, SpreadCanvas canvas) {
		this.mode.mouseDragged(e,canvas);
	}

	public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {
		this.mode.mouseEntered(e,canvas);
	}

	public void mouseExited(GSMouseEvent e, SpreadCanvas canvas) {
		this.mode.mouseExited(e,canvas);
	}

	public void mouseMoved(GSMouseEvent e, SpreadCanvas canvas) {
		mode.mouseMoved(e,canvas);		
	}

	public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
		mode.mousePressed(e, canvas);
		canvas.getSpread().clearSelection();
		if (!WorkspaceWindow.getInstance().isAlt() && canvas.containRegions(e.getPoint())) {
			State state = UniSelectedState.getInstance();
			ImageLabel.setState(state);
			state.mousePressed(e, canvas);
		}
	}

	public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
		mode.mouseReleased(e, canvas);
	}

	public void paint(Graphics g, SpreadCanvas canvas) {
		mode.paint(g,canvas);
	}

	public Mode getMode() {
		return this.mode;
	}
	
	public void addSetmodeEvent(StateEvent stateEvent){
		if(stateEvent != null){
			evnetList.add(stateEvent);
		}
	}

	@Override
	public int getType() {
		return State.DFAULT;
	}

}
