/* $Id: BookmarkMode.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.geom.Rectangle2D;
import javax.swing.JOptionPane;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.swingui.GSMouseEvent;

public class BookmarkMode  extends DrawingModeAdapter {

	private static Mode singleton = new BookmarkMode();

	public static Mode getInstance() {
		return singleton;
	}
	
	@Override
	public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas){
		String title = JOptionPane.showInputDialog("Title", "Bookmark");
		if (title != null) {
			double w = BookmarkView.WIDTH;
			double h = BookmarkView.HEIGHT;
			double x = e.getPoint().getX();
			double y = e.getPoint().getY();
			Rectangle2D rectangle = new Rectangle2D.Double(x, y, w, h);
			BookmarkView view = new BookmarkView(rectangle, title);
			BookmarkRegion region = new BookmarkRegion(canvas.getSpread(), view);
			canvas.addRegion(region);
		}
	}

}
