/* $Id: PasteImageCommand.java 125 2011-03-09 09:49:51Z ohura $ */
package image_editor.toolbar;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ImageObserver;

public class PasteImageCommand implements DrawCommand {
	
	private Image image;
	private int x;
	private int y;
	private int width;
	private int height;
	private ImageObserver observer;
	
	public PasteImageCommand(Image clippedImage, int x, int y, int width, int height,ImageObserver observer) {
		this.image = clippedImage;
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
		this.observer = observer;
	}

	public void execute(Graphics g) {
		g.drawImage(image,x,y,width,height,this.observer);
	}
	public void drawBounds(Graphics g){
		Color oldColor = g.getColor();
		g.setColor(Color.BLACK);
		g.drawLine(this.x,this.y,this.x+this.width,this.y);
		g.drawLine(x+width,y,x+width,y+height);
		g.drawLine(x+width,y+height,x,y+height);
		g.drawLine(x,y+height,x,y);
		g.setColor(oldColor);
	}
	public boolean contains(Point point) {
		int px = point.x;
		int py = point.y;
		if((this.x < px) && (px < this.x+width)){
			if((this.y < py) && (py < this.y+height)){
				return true;
			}
		}
		return false;
	}
	public void setPosition(int x,int y){
		this.x = x;
		this.y = y;
	}
	public void setPosition(Point point){
		this.setPosition(point.x,point.y);
	}

}
