package smart_gs.util;

import java.util.List;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import smart_gs.logical.SmartDocument;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.logical.TextSegment;

@SuppressWarnings("serial")
public class ResourcePanel extends JScrollPane{
	
	public ResourcePanel(){
		JPanel treePanel = new JPanel();
		treePanel.add(this.createTree());
		
		this.setViewportView(treePanel);
	}
	
	public JTree createTree(){
		JTree tree = new JTree();
		DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
		((DefaultTreeModel)tree.getModel()).setRoot(root);
		List<Spread> spreads = SpreadTree.getInstance().getSpreads();
		
		for(int i=0;i<spreads.size();i++){
			Spread spread = spreads.get(i);
			DefaultMutableTreeNode node = new DefaultMutableTreeNode(spread);
			SmartDocument transcription = spread.getTranscription();
			SmartDocument translation = spread.getTranslation();
			SmartDocument annotation = spread.getAnnotation();
			DefaultMutableTreeNode node1 = new DefaultMutableTreeNode(transcription);
			DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(translation);
			DefaultMutableTreeNode node3 = new DefaultMutableTreeNode(annotation);
			this.createNode(node1, transcription);
			this.createNode(node2, translation);
			this.createNode(node3, annotation);
			node.add(node1);
			node.add(node2);
			node.add(node3);
			root.add(node);
		}
		return tree;
	}
	private void createNode(DefaultMutableTreeNode parent,SmartDocument document){
		List<TextSegment> segments = document.getSegments();
		for(int i=0;i<segments.size();i++){
			DefaultMutableTreeNode node = new DefaultMutableTreeNode(segments.get(i));
			parent.add(node);
		}
		
	}
}
