package smart_gs.text_search.swingui;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.StyleContext;

import smart_gs.all_text_search.SearchAllDialogManager;
import smart_gs.dictionary.DictionaryDialog;
import smart_gs.logical.Spread;
import smart_gs.spread_selection.ScopePanelAction;
import smart_gs.spread_selection.SetScopePanel;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.text_search.SearchTextAction;
import smart_gs.text_search.logical.SearchResult;
import smart_gs.text_search.logical.TextSearchConstants;


@SuppressWarnings("serial")

public class TextSearchPanel extends JPanel {
	//͈͂̎w
	private SetScopePanel scopePanel;
	
	private JRadioButton allType;
	private JRadioButton transcription;
	//20080901. Texť̂߂̃WI{^ݒu
	private JRadioButton text;
	private JRadioButton annotation;
	private JRadioButton translation;
    private JTextField queryTextPane;
    private JTextField queryReplacePane;

    private JCheckBox caseSensitiveBox;
    private JCheckBox regularExpressionsBox;
    private String queryText = null;
    private JButton ok;
    private JButton replace;
    
    private static boolean allTypeSelected = true;
    private static boolean transcriptionSelected;
    private static boolean textSelected;
    private static boolean annotationSelected;
    private static boolean translationSelected;
    private static String queryTextPaneText;
    private static String queryReplacePaneText;
    private static boolean caseSensitiveBoxSelected;
    private static boolean regularExpressionsBoxSelected;
    
	public TextSearchPanel(){
//		super(new JPanel());
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
//		this.add(mainPanel, BorderLayout.CENTER);
		
		JPanel queryTextPanel = new JPanel();
		queryTextPanel.setLayout(new BorderLayout());
		queryTextPanel.setBorder(new TitledBorder(""));
		
		
		this.queryTextPane = new JTextField();
		this.queryTextPane.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,20));
		this.queryTextPane.setText(queryTextPaneText);
		
		this.queryReplacePane = new JTextField();
		this.queryReplacePane.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,20));
		this.queryReplacePane.setText(queryReplacePaneText);

//		queryTextPanel.add(queryTextPane,BorderLayout.CENTER);

		
//		Panel findPanel = new Panel();
//		findPanel.setLayout(new GridLayout(2, 2));
//		findPanel.add(new JLabel("Find:"));
//		findPanel.add(queryTextPane);
//		findPanel.add(new JLabel("Replace With:"));
//		findPanel.add(new JLabel("A2"));


		GridBagConstraints c = new GridBagConstraints();
		JPanel findPanel = new JPanel(new GridBagLayout());
		c.gridheight = 1;
		c.gridwidth  = 1;
		c.gridy = 0;

		c.gridx = 0;
		c.weightx = 0.0;
		c.insets = new Insets(2, 2, 2, 0);
		c.anchor = GridBagConstraints.WEST;
		findPanel.add(new JLabel("Find:"), c);
		
		c.gridx = 1;
		c.weightx = 1.0;
		c.fill = GridBagConstraints.HORIZONTAL;
		findPanel.add(queryTextPane, c);
		

		c.gridy = 1;
		c.gridx = 0;
		c.weightx = 0.0;
		c.insets = new Insets(2, 2, 2, 0);
		c.anchor = GridBagConstraints.WEST;
		findPanel.add(new JLabel("Replace With:"), c);
		
		c.gridx = 1;
		c.weightx = 1.0;
		c.fill = GridBagConstraints.HORIZONTAL;
		findPanel.add(queryReplacePane, c);

		queryTextPanel.add(findPanel,BorderLayout.CENTER);
		
		
		Panel boxPanel = new Panel();
		boxPanel.setLayout(new BorderLayout());
		caseSensitiveBox = new JCheckBox("Case sensitive");
		regularExpressionsBox = new JCheckBox("Regular expressions");
		boxPanel.add(regularExpressionsBox,BorderLayout.NORTH);
		boxPanel.add(caseSensitiveBox,BorderLayout.SOUTH);
		queryTextPanel.add(boxPanel, BorderLayout.SOUTH);
		
		mainPanel.add(queryTextPanel, BorderLayout.NORTH);
		
		JPanel optionPanel = new JPanel(new GridLayout(1,2));
		mainPanel.add(optionPanel, BorderLayout.CENTER);
		
		
		/*
		 * ͈͂̎wSetScopePanelɈڂ
		 */
		this.scopePanel = new SetScopePanel(true);
		this.scopePanel.setScopePanelAction(new TextSearchDialogScopePanelAction());

		optionPanel.add(scopePanel);				
		
		JPanel documentTypePanel = new JPanel(new GridLayout(4,1));
		documentTypePanel.setBorder(new TitledBorder("document type"));
		this.text = new JRadioButton("Text");
		this.text.setSelected(textSelected);
		this.transcription = new JRadioButton("Transcription");
		this.transcription.setSelected(transcriptionSelected);
		this.annotation = new JRadioButton("Annotation");
		this.annotation.setSelected(annotationSelected);
		this.translation = new JRadioButton("Translation");
		this.translation.setSelected(translationSelected);
		this.allType = new JRadioButton("All Document Types");
		this.allType.setSelected(allTypeSelected);
		this.caseSensitiveBox.setSelected(caseSensitiveBoxSelected);
		this.regularExpressionsBox.setSelected(regularExpressionsBoxSelected);
		ButtonGroup group2 = new ButtonGroup();
		
		group2.add(transcription);
		group2.add(annotation);
		group2.add(translation);
		group2.add(text);
		group2.add(allType);
		
		transcription.addActionListener(new DocumentTypeSelectAction());
		annotation.addActionListener(new DocumentTypeSelectAction());
		translation.addActionListener(new DocumentTypeSelectAction());
		text.addActionListener(new DocumentTypeSelectAction());
		allType.addActionListener(new DocumentTypeSelectAction());
		
		documentTypePanel.add(transcription);
		documentTypePanel.add(annotation);
		documentTypePanel.add(translation);
		documentTypePanel.add(text);
		documentTypePanel.add(allType);
		optionPanel.add(documentTypePanel);
		
		JPanel buttonPanel = new JPanel();
		ok = new JButton("Search");
		ok.addActionListener(new OKAction());
		buttonPanel.add(ok);
		
		replace = new JButton("Replace");
		replace.addActionListener(new ReplaceAction());
		buttonPanel.add(replace);
		
		// Ԃɐݒ肷.
		this.scopePanel.execScopePanelAction();

		this.add(mainPanel,BorderLayout.CENTER);
		this.add(buttonPanel,BorderLayout.SOUTH);
//		this.setLocationRelativeTo(null);
//		this.pack();
	}
	private class OKAction implements ActionListener{
		int documentType;
		public void actionPerformed(ActionEvent e){
			queryText = queryTextPane.getText();
			if(queryText.equals("")){
				JOptionPane.showMessageDialog(null, "type any text");				
			}else if(scopePanel.isImageDictionary()){
				DictionaryDialog dictionaryDialog = new DictionaryDialog(WorkspaceWindow.getInstance(),"Dictionary",false,0);
				dictionaryDialog.search(queryText,regularExpressionsBox.isSelected(),caseSensitiveBox.isSelected());
				dictionaryDialog.setVisible(true);
			}else{
				queryTextPaneText = queryText;
				queryReplacePaneText = queryReplacePane.getText();
				transcriptionSelected = transcription.isSelected();
				translationSelected = translation.isSelected();
				annotationSelected = annotation.isSelected();
				allTypeSelected = allType.isSelected();
				textSelected = text.isSelected();
				caseSensitiveBoxSelected = caseSensitiveBox.isSelected();
				regularExpressionsBoxSelected = regularExpressionsBox.isSelected();
				
				if(transcription.isSelected()) {
					documentType = TextSearchConstants.TRANSCRIPTION;
				}else if(translation.isSelected()){
					documentType =TextSearchConstants.TRANSLATION;
				}else if(annotation.isSelected()){
					documentType = TextSearchConstants.ANNOTATION;
				}else if(allType.isSelected()){
					documentType = TextSearchConstants.ALLDOCUMENT;
				}else if(text.isSelected()){
					documentType = TextSearchConstants.TEXT;
				}
				search(queryText,documentType,caseSensitiveBox.isSelected(),regularExpressionsBox.isSelected());
			}	
		}
	}
	private class DocumentTypeSelectAction implements ActionListener{
		public void actionPerformed(ActionEvent e){
			if(text.isSelected()){
				scopePanel.setEnabled(false);
			}else {
				scopePanel.setEnabled(true);
			}
		}
	}

	private class ReplaceAction implements ActionListener{
		int documentType;
		public void actionPerformed(ActionEvent e){
			queryText = queryTextPane.getText();
			if(queryText.equals("")){
				JOptionPane.showMessageDialog(null, "type any text");
			}else if(scopePanel.isImageDictionary()){
				// x
			}else{
				queryTextPaneText = queryText;
				queryReplacePaneText = queryReplacePane.getText();
				transcriptionSelected = transcription.isSelected();
				translationSelected = translation.isSelected();
				annotationSelected = annotation.isSelected();
				allTypeSelected = allType.isSelected();
				textSelected = text.isSelected();
				caseSensitiveBoxSelected = caseSensitiveBox.isSelected();
				regularExpressionsBoxSelected = regularExpressionsBox.isSelected();
				
				if(transcription.isSelected()) {
					documentType = TextSearchConstants.TRANSCRIPTION;
				}else if(translation.isSelected()){
					documentType =TextSearchConstants.TRANSLATION;
				}else if(annotation.isSelected()){
					documentType = TextSearchConstants.ANNOTATION;
				}else if(allType.isSelected()){
					documentType = TextSearchConstants.ALLDOCUMENT;
				}else if(text.isSelected()){
					documentType = TextSearchConstants.TEXT;
				}
				SearchAllDialogManager.setting(queryText, queryReplacePaneText, regularExpressionsBoxSelected, caseSensitiveBoxSelected);
				int scope = 0;
				String spreadSelection = "";
				if(scopePanel.isAll()){
					scope = 0;
				}else if(scopePanel.isCurrentDirectory()){
					scope = 1;
				}else if(scopePanel.isSelectSpread()){
					scope = 2;
					spreadSelection = scopePanel.getSelectedPage();
				}
				SearchAllDialogManager.findfirst(documentType,scope,spreadSelection);
//				dispose();
			}	
		}
	}

	private void search(String queryText, int documentType,boolean isCaseSensitive,boolean isRegularExpressions){
//		List<Spread> spreads = this.getSpreadsToSearch();
		List<Spread> spreads = this.scopePanel.getSpreadsToSearch();
		ArrayList<Spread> spreadsToSearch = new ArrayList<Spread>();
		for(int i=0;i<spreads.size();i++){
			spreadsToSearch.add(spreads.get(i));
		}		
		SearchTextAction searchAction = new SearchTextAction(queryText,spreadsToSearch,documentType,isCaseSensitive,isRegularExpressions);
		searchAction.execute();
		ArrayList<SearchResult> results = (ArrayList<SearchResult>)searchAction.getResults();
		new SearchResultViewer(queryText,results).setVisible(true);				
//		dispose();
	}
	
	public void actionPerformed(ActionEvent e) {
		
	}
	class TextSearchDialogScopePanelAction implements ScopePanelAction{

		public void actionPerformed(SetScopePanel setScopePanel) {
			if(setScopePanel.isImageDictionary()){
				allType.setEnabled(false);
				transcription.setEnabled(false);
				text.setEnabled(false);
				annotation.setEnabled(false);
				translation.setEnabled(false);
				replace.setEnabled(false);
			}else{
				allType.setEnabled(true);
				transcription.setEnabled(true);
				text.setEnabled(true);
				annotation.setEnabled(true);
				translation.setEnabled(true);
				replace.setEnabled(true);
			}
		}
		
	}
}
