package smart_gs.reasoning_web.desktop.logical;

import javax.swing.JPanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.logical.StandardTextDocument;
import smart_gs.logical.XML2ResourceConverter;
import smart_gs.reasoning_web.desktop.swingui.DesktopWindow;
import smart_gs.reasoning_web.desktop.swingui.view.DesktopElementView;
import smart_gs.reasoning_web.desktop.swingui.view.ShortCutView;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.XML2RWElementConverter;

public class ShortCut extends DesktopElement{
	
	private GS_RWElement resource;
	
	public ShortCut(){
		super();
	}
	
	public ShortCut(GS_RWElement resource,String name,StandardTextDocument memo){
		super(DesktopWindow.getInstance().getRootFolder(),name,memo);
		this.resource = resource;
		this.setName(this.name);
	}
	@Override
	public DesktopElementView createView() {
		return new ShortCutView();
	}
	
	public void open() {
		this.resource.show();
	}
	public void setParentFolder(DeskTopFolder parent) {
		this.parent = parent;
	}
	public Element createXMLElement(Document document) {
		Element element = document.createElement("shortcut");
		element.setAttribute("name",this.name);
		element.setAttribute("resourceURI",this.resource.getURI());
		element.appendChild(this.resource.createXMLElement(document));
		element.appendChild(this.memo.createXMLElement(document));
		return element;
	}
	public void setResouce(GS_RWElement resouce) {
		this.resource = resouce;
	}
	public static ShortCut restore(Element element) {
		String name = element.getAttribute("name");
		String source = element.getAttribute("source");
		ShortCut shortcut = new ShortCut();
		shortcut.setName(name);
		shortcut.setString(source);
		NodeList list = element.getChildNodes();
		for(int i=0;i<list.getLength();i++){
			if(list.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)list.item(i);
				if(elem.getNodeName().equals("standardDocument")){
					StandardTextDocument memo = (StandardTextDocument) XML2ResourceConverter.convert(elem);
					shortcut.setMemo(memo);
				}else{
					GS_RWElement resource = XML2RWElementConverter.convert((Element)list.item(i));
					shortcut.setResouce(resource);
				}
			}
		}

		return shortcut;
	}



	public JPanel createElementViewPanel() throws NoWayToShowException {
		return null;
	}

	public String getURI() {
		return this.resource.getURI();
	}

	public void show() {
		this.resource.show();
		
	}

	public GS_RWElement getResource() {
		return this.resource;
	}
}
