package smart_gs.menu;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;


import jp.ac.hokudai.meme.core_smart_gs.searcher.IDocumentSearcher;

import smart_gs.GSConstants;
import smart_gs.PreferenceManager;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.Preference;
import smart_gs.menu.action.ChangeMainTypeAction;
import smart_gs.menu.action.ChangeSearchTypeAction;
import smart_gs.menu.action.ChangeTextTypeAction;
import smart_gs.menu.action.LoadFileAction;
import smart_gs.menu.action.MemoPadChangeDefaultColorAction;
import smart_gs.menu.action.RectangleMoveAction;
import smart_gs.menu.action.SetCurrentDirectoryAction;
import smart_gs.menu.action.SetImageFolderPathAction;
import smart_gs.menu.action.SetDocumentFolderPathAction;
import smart_gs.menu.action.SetDscFolderPathAction;
import smart_gs.menu.action.SetLineFolderPathAction;
import smart_gs.menu.action.SetSmart_gsFolderPathAction;
import smart_gs.swingui.WorkspaceWindow;
import webdav.preference.ProxySetting;
import webdav.preference.WebDavSetting;

@SuppressWarnings("serial")
public class PreferenceMenu extends JMenu {

	public PreferenceMenu(String title) {
		super(title);

		JMenuItem userName = new JMenuItem("Set User Name");
		userName.addActionListener(new ChangeUserNameAction());
		this.add(userName);
        //20080715 shimizu
		/*
		 * ꕔ̃j[WI{^j[ɕύX
		 */
		JMenu changeMainPanel = new JMenu("Change Main Panel");
		int panel = PreferenceManager.getInstance().getMainDocumentType();
		JMenuItem image = new JRadioButtonMenuItem("Image",panel==GSConstants.IMAGE);
		JMenuItem transcription = new JRadioButtonMenuItem("Transcription",panel==GSConstants.TRANSCRIPTION);
		JMenuItem translation = new JRadioButtonMenuItem("Translation",panel==GSConstants.TRANSLATION);
		JMenuItem annotation = new JRadioButtonMenuItem("Annotation",panel==GSConstants.ANNOTATION);
		image.addActionListener(new ChangeMainTypeAction(GSConstants.IMAGE));
		transcription.addActionListener(new ChangeMainTypeAction(
				GSConstants.TRANSCRIPTION));
		translation.addActionListener(new ChangeMainTypeAction(
				GSConstants.TRANSLATION));
		annotation.addActionListener(new ChangeMainTypeAction(
				GSConstants.ANNOTATION));
		ButtonGroup panelGroup = new ButtonGroup();
		panelGroup.add(image);
		panelGroup.add(transcription);
		panelGroup.add(translation);
		panelGroup.add(annotation);
		changeMainPanel.add(image);
		changeMainPanel.add(transcription);
		changeMainPanel.add(translation);
		changeMainPanel.add(annotation);
		this.add(changeMainPanel);

		//20090118 North Grid Add
		JMenu imageSearchEngine = new JMenu("Image Search Engine");
		boolean isExternalEngine = GSSearchEngine.getInstance().isUseExternalEngine();
		JMenuItem externalEngine = new JRadioButtonMenuItem("External",isExternalEngine);
		externalEngine.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				GSSearchEngine.getInstance().setUseExternalEngine(true);
			}
		});
		
		JMenuItem internalEngine = new JRadioButtonMenuItem("Internal",isExternalEngine==false);
		internalEngine.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				GSSearchEngine.getInstance().setUseExternalEngine(false);
			}
		});
		ButtonGroup imageSearchEngineGroup = new ButtonGroup();
		imageSearchEngineGroup.add(externalEngine);
		imageSearchEngineGroup.add(internalEngine);
		imageSearchEngine.add(externalEngine);
		imageSearchEngine.add(internalEngine);

		this.add(imageSearchEngine);
		
		
		
		//20090909 North Grid Add
		JMenu imageSearchType = new JMenu("Image Search Type in Dictionary");
		String type = Preference.getInstance().getSearchImageDictionaryLogic();
		boolean isType1 = false;
		boolean isType2 = false;
		boolean isType3 = false;
		if(type.equals("0")){
			isType1 = true;
		}else if(type.equals("1")){
			isType2 = true;
		}else if(type.equals("2")){
			isType3 = true;
		}else {
			isType1 = true;
		}
		JMenuItem type1 = new JRadioButtonMenuItem("Type1",isType1);
		type1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().setSearchImageDictionaryLogic("0");
			}
		});
		JMenuItem type2 = new JRadioButtonMenuItem("Type2",isType2);
		type2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().setSearchImageDictionaryLogic("1");
			}
		});
		JMenuItem type3 = new JRadioButtonMenuItem("Type3",isType3);
		type3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().setSearchImageDictionaryLogic("2");
			}
		});
		ButtonGroup imageSearchTypeGroup = new ButtonGroup();
		imageSearchTypeGroup.add(type1);
		imageSearchTypeGroup.add(type2);
		imageSearchTypeGroup.add(type3);

		imageSearchType.add(type1);
		imageSearchType.add(type2);
		imageSearchType.add(type3);

		this.add(imageSearchType);
		
		
		JMenu searchType = new JMenu("Search Type");
		int s = GSSearchEngine.getInstance().getSearchType();
		JMenuItem defaultType = new JRadioButtonMenuItem("Default",s==IDocumentSearcher.TYPE_NORMAL);
		defaultType.addActionListener(new ChangeSearchTypeAction(
				IDocumentSearcher.TYPE_NORMAL));
		JMenuItem dtw1 = new JRadioButtonMenuItem("DTW_1",s==IDocumentSearcher.TYPE_DTW_1);
		dtw1.addActionListener(new ChangeSearchTypeAction(
				IDocumentSearcher.TYPE_DTW_1));
		JMenuItem dtw2 = new JRadioButtonMenuItem("DTW_2",s==IDocumentSearcher.TYPE_DTW_2);
		dtw2.addActionListener(new ChangeSearchTypeAction(
				IDocumentSearcher.TYPE_DTW_2));
		ButtonGroup searchGroup = new ButtonGroup();
		searchGroup.add(defaultType);
		searchGroup.add(dtw1);
		searchGroup.add(dtw2);
		searchType.add(defaultType);
		searchType.add(dtw1);
		searchType.add(dtw2);

		this.add(searchType);
		//20080715 shimizu wrote
		JMenu textType = new JMenu("Text Type");
		JMenuItem horizontal = new JRadioButtonMenuItem("Horizontal",TextType.isHorizontal());
		horizontal.addActionListener(new ChangeTextTypeAction(
				TextType.HORIZONTAL));
		JMenuItem vertical = new JRadioButtonMenuItem("Vertical",TextType.isHorizontal()==false);
		vertical.addActionListener(new ChangeTextTypeAction(
				TextType.VERTICAL));
		ButtonGroup textTypeGroup = new ButtonGroup();
		textTypeGroup.add(horizontal);
		textTypeGroup.add(vertical);
		textType.add(horizontal);
		textType.add(vertical);
		
		this.add(textType);
		

		JMenuItem maxSearchNum = new JMenuItem("Set Search Found Size");
		this.add(maxSearchNum);
		maxSearchNum.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String sizeStr = JOptionPane
						.showInputDialog("Input Max Found Size");
				if (sizeStr == null) {
					return;
				}
				try {
					int size = Integer.parseInt(sizeStr);
					GSSearchEngine.getInstance().setMaxFound(size);
				} catch (NumberFormatException nfe) {
					nfe.printStackTrace();
				}
			}
		});

		JMenuItem load = new JMenuItem("Load All Images");
		load.addActionListener(new LoadFileAction());

		this.add(load);

		/*
		 * menu̒ǉ(2007/9/11) reactangleɊւ
		 */
		// JMenu rectangleMenu = new JMenu("Rectangle");
		JMenu regionMenu = new JMenu("Region"); // 2010/12/01 kukita altered the name of this menu item
		//JMenu rectangleMove = new JMenu("Move or NotMove");
		JMenu rectangleMove = new JMenu("Movability"); // 2010/12/01 kukita
		boolean rec = UniSelectedState.getInstance().getRectangleMovability();
		JMenuItem move = new JRadioButtonMenuItem("Movable",rec);
		JMenuItem notMove = new JRadioButtonMenuItem("UnMovable",rec==false);
		ButtonGroup recGroup = new ButtonGroup();
		recGroup.add(move);
		recGroup.add(notMove);
		rectangleMove.add(move);
		rectangleMove.add(notMove);
		//rectangleMenu.add(rectangleMove);
		regionMenu.add(rectangleMove); // 2010/12/01 kukita
		move.addActionListener(new RectangleMoveAction(true));
		notMove.addActionListener(new RectangleMoveAction(false));
		//this.add(rectangleMenu);
		this.add(regionMenu);// 2010/12/01 kukita

		// 2010/11/30 kukita
		JMenu memoPadDefaultColor = new JMenu("MemoPad Default Color");
		Color dc = MemoPadView.DEFAULT_COLOR;
		JMenuItem yellow = new JRadioButtonMenuItem("Yellow",dc == MemoPadView.MEMOPAD_YELLOW);
		JMenuItem cyan = new JRadioButtonMenuItem("Cyan",dc == MemoPadView.MEMOPAD_CYAN);
		JMenuItem magenta = new JRadioButtonMenuItem("Magenta",dc == MemoPadView.MEMOPAD_MAGENTA);
		JMenuItem green = new JRadioButtonMenuItem("Green",dc == MemoPadView.MEMOPAD_GREEN);
		ButtonGroup memoPadColorGroup = new ButtonGroup();
		memoPadColorGroup.add(yellow);
		memoPadColorGroup.add(cyan);
		memoPadColorGroup.add(magenta);
		memoPadColorGroup.add(green);
		memoPadDefaultColor.add(yellow);
		memoPadDefaultColor.add(cyan);
		memoPadDefaultColor.add(magenta);
		memoPadDefaultColor.add(green);
		yellow.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MemoPadColor.YELLOW));
		cyan.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MemoPadColor.CYAN));
		magenta.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MemoPadColor.MAGENTA));
		green.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MemoPadColor.GREEN));
		//rectangleMenu.add(memoPadDefaultColor);
		regionMenu.add(memoPadDefaultColor);// 2010/12/01 kukita
		
		
		// 2007/10/7 kazuhiro kobayashi
		// FileChooserJƂ̍ŏ̃fBNgݒ
		JMenuItem setGsFolderPath = new JMenuItem("gs");
		setGsFolderPath.addActionListener(new SetCurrentDirectoryAction());
		// this.add(setCurrentDirectory);
		// 2007/10/10 kazuhiro kobayashi
		/*
		 * ÕtH_ɂ邱̃t@CgƂł
		 */
		JMenuItem setImageFolderPath = new JMenuItem("image");
		setImageFolderPath.addActionListener(new SetImageFolderPathAction());

		JMenuItem setDocumentFolderPath = new JMenuItem("textDocument");
		setDocumentFolderPath
				.addActionListener(new SetDocumentFolderPathAction());

		JMenuItem setDscFolderPath = new JMenuItem("dsc");
		setDscFolderPath.addActionListener(new SetDscFolderPathAction());

		JMenuItem setLineFolderPath = new JMenuItem("line");
		setLineFolderPath.addActionListener(new SetLineFolderPathAction());

		//2007/10/11 kazuhiro kobayashi
		JMenuItem setSmart_gsFolderPath = new JMenuItem("smart_gs");
		setSmart_gsFolderPath.addActionListener(new SetSmart_gsFolderPathAction());
		
		/* 20080909 name correspondance @\폜̂߁B@hashimoto
		 * 
		//2007/11/20 kazuhiro kobayashi
		JMenuItem setNameCorrespondenceFilePath = new JMenuItem("name correspondence");
		setNameCorrespondenceFilePath.addActionListener(new SetNameCorrespondenceAction());
		*/
		
		JMenuItem setDirectoryPath = new JMenuItem("Set Directory Path");
		setDirectoryPath.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				DirectorySettingWindow.getInstance().setVisible(true);
			}
		});
		
		this.add(setDirectoryPath);
		// ADD NorthGrid 2009/01/31
		JMenuItem setWebDavSetting = new JMenuItem("WebDAV Setting");
		setWebDavSetting.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				WebDavSetting webDavSetting = new WebDavSetting(WorkspaceWindow.getInstance(),true);
				webDavSetting.setLocationRelativeTo(null);
				webDavSetting.setVisible(true);
			}
		});
		this.add(setWebDavSetting);

		// ADD NorthGrid 2010/04/19
		JMenuItem setProxySetting = new JMenuItem("Proxy Setting");
		setProxySetting.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				ProxySetting proxySetting = new ProxySetting(WorkspaceWindow.getInstance(),true);
				proxySetting.setLocationRelativeTo(null);
				proxySetting.setVisible(true);
			}
		});
		this.add(setProxySetting);

		// ADD NorthGrid 2009/02/22
		JMenuItem setWebBrowser = new JMenuItem("Web Browser Setting");
		setWebBrowser.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				BrowserSettingDialog browserSettingDialog = new BrowserSettingDialog(WorkspaceWindow.getInstance());
				browserSettingDialog.setLocationRelativeTo(null);
				browserSettingDialog.setVisible(true);
			}
		});
		this.add(setWebBrowser);
		
		
		// ADD NorthGrid 2009/02/22
		JMenuItem setEditor = new JMenuItem("Editor Setting");
		setEditor.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				EditorSettingDialog editorSettingDialog = new EditorSettingDialog(WorkspaceWindow.getInstance());
				editorSettingDialog.setLocationRelativeTo(null);
				editorSettingDialog.setVisible(true);
			}
		});
		this.add(setEditor);
	}
}
