package smart_gs.drawing_tool.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import smart_gs.logical.Region;


public abstract class View {
	
	public static int RECTANGLE = 0;
	public static int MARKER = 1;
	public static int LASSO = 2;
	public static int LINE_SEGMENT = 3;
	public static int LINE = 4;
	public static int MEMOPAD = 5;
	
	protected boolean isSelected;
	protected boolean isEmphasized;
	//
	protected boolean isProtected;
	
	protected Color defaultColor;
	protected Stroke defaultStroke;
	protected Color selectionColor;
	protected Stroke selectionStroke;
	protected Color emphasizeColor;
	protected Stroke emphasizeStroke;
	//
	protected Color protectedColor;
	protected Stroke protectedStroke;
	
	protected View(){
		this.selectionColor = Color.RED;
		this.selectionStroke = new BasicStroke();
		this.emphasizeColor = Color.RED;
		this.emphasizeStroke = new BasicStroke(5);
		
		Color c = new Color(50,150,100);
		this.protectedColor = c;
		this.protectedStroke = new BasicStroke(2);
		
		this.defaultColor = Color.black;
	}
	
	public abstract void moveBy(Point2D d);
	public abstract boolean contains(Point2D point);
	public abstract View enlargedView(double ratio,double gapX,double gapY);
	public boolean isSelected(){
		return this.isSelected;
	}
	public void setIsSelected(boolean isSelected) {
		this.isSelected = isSelected;
	}
	public void setIsEmphasized(boolean isEmphasized){
		this.isEmphasized = isEmphasized;
	}
	/*
	 *2007/9/13 
	 */
	public void setIsProtected(String protection){
		//kazuhiro kobayashi 10/7
		this.isProtected = protection.equals(Region.PROTECTED);
	}
	
	public final void draw(Graphics2D g){
		Color oldColor = g.getColor();
		Stroke oldStroke = g.getStroke();
		if(this.isEmphasized){
			g.setColor(this.emphasizeColor);
			g.setStroke(this.emphasizeStroke);
		}
		else if(this.isSelected){
			g.setColor(this.selectionColor);
			g.setStroke(this.selectionStroke);
		}
		else if(this.isProtected){
			g.setColor(this.protectedColor);
			g.setStroke(this.protectedStroke);
		}
		else{
			g.setColor(this.defaultColor);
			if(this.defaultStroke != null){
				g.setStroke(this.defaultStroke);
			}
		}
		
		this.drawShape(g);
		g.setColor(oldColor);
		g.setStroke(oldStroke);
	}
	protected abstract void drawShape(Graphics2D g);
	
	public Color getSelectionColor() {
		return this.selectionColor;
	}
	public Stroke getSelectionStroke(){
		return this.selectionStroke;
	}
	public Color getProtectedColor(){
		return this.protectedColor;
	}
	public Stroke getProtectedStroke(){
		return this.protectedStroke;
	}
	public void setSelectionColor(Color color){
		this.selectionColor = color;
	}
	public void setSelectionStroke(Stroke stroke){
		this.selectionStroke = stroke;
	}
	public void setProtectedColor(Color color){
		this.protectedColor = color;
	}
	public void setProtectedStroke(Stroke stroke){
		this.protectedStroke = stroke;
	}
	public abstract Rectangle2D getRectangle2D();

	public final Rectangle getRectangle() {
		Rectangle2D rect = this.getRectangle2D();
		int x = (int)rect.getX();
		int y = (int)rect.getY();
		int width = (int)rect.getWidth();
		int height = (int)rect.getHeight();
		Rectangle r = new Rectangle(x,y,width,height);
		return r;
	}
	public abstract String getTypeString();
	public abstract int getType();
	public abstract void drawLinkedShape(Graphics2D g);
	public abstract Element createXMLElement(Document document);
	public boolean containsInCorner(Point2D point) {
		return false;
	}
	public boolean isResizable() {
		return false;
	}
	public void resize(Point2D d) {
	}

	public boolean isProtected() {
		return this.isProtected;
	}
}
