package smart_gs.drawing_tool;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import smart_gs.connection.ConnectionCreator;
import smart_gs.dictionary.DictionaryRegisterDialog;
import smart_gs.drawing_tool.action.AddRegionToNoteAction;
import smart_gs.drawing_tool.action.CreateNoteAction;
import smart_gs.drawing_tool.action.CreateShortCutAction;
import smart_gs.drawing_tool.action.DeleteArrowAction;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.drawing_tool.action.MemoPadChangeColorAction;
import smart_gs.drawing_tool.action.MemoPadTextAction;
import smart_gs.drawing_tool.action.ProtectRegionAction;
import smart_gs.drawing_tool.action.ReleaseProtectedRegionAction;
import smart_gs.drawing_tool.action.SetLinkSourceAction;
import smart_gs.drawing_tool.action.SetLinkTargetAction;
import smart_gs.drawing_tool.action.DrawArrowAction;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;

@SuppressWarnings("serial")
public class RightClickMenu extends JPopupMenu{	
	
	public RightClickMenu(final Region region, SpreadCanvas canvas) {
		JMenuItem delete = new JMenuItem("Delete");
		delete.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				new DeleteRegionAction(region).execute();
			}
		});
		this.add(delete);
		this.addSeparator();
		
		JMenuItem setSource = new JMenuItem("Set Link Source");
		setSource.addActionListener(new SetLinkSourceAction(region));
		this.add(setSource);
		
		JMenuItem setTarget = new JMenuItem("Set Link Target");
	    if(ConnectionCreator.isSourceSet()){
	    	setTarget.setEnabled(true);
	    	setTarget.addActionListener(new SetLinkTargetAction(region));
	    }else{
	    	setTarget.setEnabled(false);
	    }
	    
	    this.add(setTarget);

	    JMenuItem createShortcut = new JMenuItem("Create Short Cut");
	    createShortcut.addActionListener(new CreateShortCutAction(region));
	    //20080622 shimizu wrote
		//this.add(createShortcut);
		
		//this.addSeparator();
		
		JMenuItem createNote = new JMenuItem("Create Note");
		createNote.addActionListener(new CreateNoteAction(region));
		//20080622 shimizu wrote
		//this.add(createNote);
		
		JMenuItem addRegionToNote = new JMenuItem("Add to Previous Note");
		addRegionToNote.addActionListener(new AddRegionToNoteAction(region));
		//20080622 shimizu wrote
		//this.add(addRegionToNote);
		
		/*
		 *@kazuhiro kobayashi
		 */
		this.addSeparator();
		
		if (region.isProtected().equals(Region.NORMAL)){
			JMenuItem protectRegion = new JMenuItem("Protect Region");
			protectRegion.addActionListener(new ProtectRegionAction(region));
			this.add(protectRegion);
		} else {
			JMenuItem releaseProtectedRegion = new JMenuItem("Release Protection of Region");
			releaseProtectedRegion.addActionListener(new ReleaseProtectedRegionAction(region));
			this.add(releaseProtectedRegion);
		}
		
//		JMenuItem makeNewSheet = new JMenuItem("make new sheet");
//		makeNewSheet.addActionListener(new MakeNewSheetAction(region));
//		this.add(makeNewSheet);
		
		/*
		 *@tsukushi shimizu
		 */
		JMenuItem jump = new JMenuItem("Show Local View");
		if(!GS_RWRepository.getInstance().hasLink(region)){
			jump.setEnabled(false);
		}
		jump.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				new ShowLocalViewAction(region).execute();
			}
		});
		this.add(jump);
		
		
		/**
		 *
		 */
		JMenuItem registDic = new JMenuItem("Register in the dictionary");
		registDic.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				DictionaryRegisterDialog dialog = new DictionaryRegisterDialog(WorkspaceWindow.getInstance(), "Register" , true,region);
				dialog.setVisible(true);
			}
		});
		this.add(registDic);
		
		if (region.getView().getType() == View.MEMOPAD) {
			this.addSeparator();

			JMenuItem addText = new JMenuItem("Add Text");
			addText.addActionListener(new MemoPadTextAction(region));
			this.add(addText);
			
			JMenu changeColor = new JMenu("Change Color");
			JMenuItem yellow = new JMenuItem("Yellow");
			yellow.addActionListener(new MemoPadChangeColorAction(region, MemoPadView.MemoPadColor.YELLOW));
			changeColor.add(yellow);

			JMenuItem cyan = new JMenuItem("Cyan");
			cyan.addActionListener(new MemoPadChangeColorAction(region, MemoPadView.MemoPadColor.CYAN));
			changeColor.add(cyan);
			
			JMenuItem magenta = new JMenuItem("Magenta");
			magenta.addActionListener(new MemoPadChangeColorAction(region, MemoPadView.MemoPadColor.MAGENTA));
			changeColor.add(magenta);

			JMenuItem green = new JMenuItem("Green");
			green.addActionListener(new MemoPadChangeColorAction(region, MemoPadView.MemoPadColor.GREEN));
			changeColor.add(green);
			
			changeColor.addSeparator();

			JMenuItem transparent = new JMenuItem("Transparent");
			transparent.addActionListener(new MemoPadChangeColorAction(region, MemoPadView.MemoPadColor.TRANSPARENT));
			JMenuItem opaque = new JMenuItem("Opaque");
			opaque.addActionListener(new MemoPadChangeColorAction(region, MemoPadView.MemoPadColor.OPAQUE));
			
			if (((MemoPadView)region.getView()).isTransparent()) {
				changeColor.add(opaque);
			} else {
				changeColor.add(transparent);
			}
			this.add(changeColor);

			JMenuItem drawArrow = new JMenuItem("Draw Arrow");
			drawArrow.addActionListener(new DrawArrowAction(region, canvas));
			this.add(drawArrow);

			if (((MemoPadView)region.getView()).getArrows().size() != 0) {
				JMenuItem deleteArrow = new JMenuItem("Delete Arrow");
				deleteArrow.addActionListener(new DeleteArrowAction(region, canvas));
				this.add(deleteArrow);

			}
		}

	}
	
}
