package smart_gs.logical;


import javax.swing.JPanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import reasoning_web.logical.NotMarkupException;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.logical.visitor.Acceptor;
import smart_gs.logical.visitor.CreateXMLElementVisitor;
import smart_gs.logical.visitor.ShowResourceVisitor;
import smart_gs.logical.visitor.Visitor;
import smart_gs.reasoning_web.logical.GS_RWElement;

public abstract class GSResource implements GS_RWElement,Acceptor{
	
	protected String uri;
	protected String name;
	protected int id;
	
	public static final String NAME = "name";
	public static final String ID = "id";
	public static final String URI = "uri";
	
	//2007/11/20 kazuhiro kobayashi
	protected String userName;
	protected String systemName;
	//
	
//	public GSResource(){
//		
//	}
	public GSResource(String uri){
		this.uri = uri;
		this.name = "";
		this.id = this.hashCode() % 1000;
	}
	public void setId(int id) {
		this.id = id;
	}
	public int getId() {
		return id;
	}
	public String getURI(){
		return this.uri;
	}	
	public void setURI(String uri){
		this.uri = uri;
	}
	public String getName(){
		return this.name;
	}
	public void setName(String name){
		this.name = name;
	}

	public final void show() {
		ShowResourceVisitor visitor = new ShowResourceVisitor();
		this.accept(visitor);
	}
	public String getSource() throws NotMarkupException{
		throw new NotMarkupException();
	}
	public JPanel createElementViewPanel() throws NoWayToShowException {
		throw new NoWayToShowException();
	}
	@Override
	public String toString() {
		return this.uri;
//		return this.name;
	}
	public final Element createXMLElement(Document document){
		CreateXMLElementVisitor visitor = new CreateXMLElementVisitor(document);
		this.accept(visitor);
		return visitor.getLastElement();
	}
	
	public abstract void accept(Visitor visitor);
	
	//2007/11/20 kazuhiro kobayashi
	/**
	 * Stringz󂯂āAsystemNamev̂userNameݒ肷B
	 */
	public void setUserName(String[] names){
		if(names[0].equals(this.systemName)){
			this.userName = names[1];
		}
	}
}
