package smart_gs.drawing_tool.drawing_mode;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;


import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.SpreadCanvas;
//import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.FreeLineView;
import smart_gs.logical.region.FreeLineRegion;
import smart_gs.swingui.GSMouseEvent;

public class FreeLineMode extends DrawingModeAdapter{
	
	private static Mode singleton = new FreeLineMode();
	
	private Point2D start;
	private Point2D end;
	private List<ExLine2D> lines;
	
	private FreeLineMode() {
		this.lines = new ArrayList<ExLine2D>();
	}
	public static Mode getInstance(){
		return singleton;
	}
	@Override
	public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
		super.mousePressed(e, canvas);
		this.start = e.getPoint();
	}
	@Override
	public void mouseDragged(GSMouseEvent e,SpreadCanvas canvas) {
		super.mouseDragged(e,canvas);
		this.end = e.getPoint();
		this.lines.add(new ExLine2D(start,end));
		this.start = this.end;
	}
	@Override
	public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
		super.mouseReleased(e, canvas);
		canvas.addRegion(new FreeLineRegion(canvas.getSpread(),this.lines));
		this.lines.clear();
		this.start = null;
		this.end = null;
//		DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
	}
	@Override
	/*
	 * temporaryView`
	 * 
	 */
	public void paint(Graphics g,SpreadCanvas canvas) {
		super.paint(g,canvas);
		double ratio = canvas.getImageLabel().getRatio();
		double gapX = canvas.getImageLabel().getGapWidth();
		double gapY = canvas.getImageLabel().getGapHeight();
		new FreeLineView(this.lines).enlargedView(ratio, gapX, gapY).draw((Graphics2D)g);
	}
}
