package smart_gs.dictionary;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import reasoning_web.logical.Connection;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.logical.GSResource;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Preference;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.logical.XML2ResourceConverter;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;
import smart_gs.swingui.tree.action.AddDirectoryAction;
import smart_gs.util.BmpFileCreator;
import smart_gs.util.SegmentInfoCreator;

public class DictionaryXML {
	private static int[] charint = {Integer.parseInt("FFE5",16)};
//	public static final String DICTIONARY = new String(charint,0,1) + "dictionary"; 
	public static final String DICTIONARY = "~dictionary"; 
	
	protected static DictionaryXML singleton;
	protected String dictionaryfilename;
	protected TreeMap<String, Dictionary> dictionaryMap = new TreeMap<String, Dictionary>();
	protected List<Spread> loadSpreads = new ArrayList<Spread>();
	protected static boolean warning = false;
	
	public static void main(String args[]){
		new DictionaryXML().load();
	}

	protected DictionaryXML(){
		
	}
	
	public static DictionaryXML getInstance(){
		if(singleton == null){
			singleton = new DictionaryXML();
			singleton.load();
		}
		return singleton;
	}
	
	public static void setWarning(boolean flg){
		warning = flg;
		singleton = null;
	}
	
	/*
	public void load(){
		load(false);
	}
	*/
	public void load(){
//		XML2ResourceConverter.getSpread(parent, element)
		loadSpreads.clear();
		dictionaryMap.clear();
		// SpreadpMap쐬
		HashMap<String, Spread> spreadMap = new HashMap<String, Spread>();
		
		List<Spread> spreadlist = SpreadTree.getInstance().getSpreads();
		for(int i=0;i<spreadlist.size();i++){
			Spread spread = spreadlist.get(i);
			spreadMap.put(spread.getURI(), spread);
		}
		
		DocumentBuilder builder;
		dictionaryfilename = Preference.getInstance().getDictionary();
		if(dictionaryfilename == null){
			return;
		}
		File file = new File(dictionaryfilename);
		if(!file.exists()){
			return;
		}
		try {
			builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document document = builder.parse(file);
			Element rootElement = document.getDocumentElement();
			
			NodeList list = rootElement.getElementsByTagName("index");
			for (int i=0; i < list.getLength() ; i++) {
				Element element = (Element)list.item(i);
				String word = element.getAttribute("word");

				// Spread擾
				NodeList spreadList = element.getElementsByTagName("spread");
				Dictionary dictionary = new Dictionary();
				dictionary.setWord(word);
				for (int j=0; j < spreadList.getLength() ; j++) {
					Element spreadElement = (Element)spreadList.item(j);
					String uri = spreadElement.getAttribute(GSResource.URI);
					Spread spread  = spreadMap.get(uri);
					if(spread != null){
//						if(loadSpreadsmode){
							if(!loadSpreads.contains(spread)){
								loadSpreads.add(spread);
							}
//						}
						NodeList regionList = spreadElement.getElementsByTagName("region");
						Element regionElement = (Element)regionList.item(0);
						Region region = XML2ResourceConverter.getRegion(spread, regionElement);
						
						DictionaryRegion dictionaryRegion = new DictionaryRegion();
						dictionaryRegion.setUri(region.getSpread().getURI());
						dictionaryRegion.setRegion(region);
						dictionary.addDictionaryRegionList(dictionaryRegion);
					}else{
						if(!warning){
							JOptionPane.showMessageDialog(WorkspaceWindow.getInstance(),"A part of image was not able to be displayed because the image file did not exist","Waring",JOptionPane.WARNING_MESSAGE);
							warning = true;
						}
					}
				}
				dictionaryMap.put(word, dictionary);
			}
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}		
	}
	
	public List<Spread> getLoadSpreads(){
		return loadSpreads;
	}

	public TreeMap<String, Dictionary> getDictionaryMap(){
		return dictionaryMap;
	}

	public TreeMap<String, Dictionary> getDictionaryMap(String filter){
		TreeMap<String, Dictionary> resultMap = new TreeMap<String, Dictionary>();
		Iterator<String> itr = dictionaryMap.keySet().iterator();
		while(itr.hasNext()){
			String word = itr.next();
			if(word.startsWith(filter)){
				resultMap.put(word, dictionaryMap.get(word));
			}
		}
		return resultMap;
	}
	public TreeMap<String, Dictionary> getDictionaryMapByregularExpressions(String filter){
		TreeMap<String, Dictionary> resultMap = new TreeMap<String, Dictionary>();
		Iterator<String> itr = dictionaryMap.keySet().iterator();
		Pattern p = Pattern.compile(filter);

		
		while(itr.hasNext()){
			String word = itr.next();
			Matcher m = p.matcher(word);
		    while(m.find()){
				resultMap.put(word, dictionaryMap.get(word));
		    }
		}
		return resultMap;
	}

	/*
	public int getMaximage(){
		return maximage;
	}
	*/
	public ArrayList<String> getWordList(String matchstr){
		if(dictionaryMap.size() == 0){
			return null;
		}
		ArrayList<String> wordList = new ArrayList<String>();
		Iterator<String> itr = dictionaryMap.keySet().iterator();
		int i=0;
		while(itr.hasNext()){
			String word = itr.next();
			if(word.startsWith(matchstr)){
				wordList.add(word);
			}
		}
		return wordList;
	}
	public void add(String word,Region region_){
		Region region = createDSC(region_);
		
		if(dictionaryMap.containsKey(word)){
			Dictionary dictionary = dictionaryMap.get(word);

			DictionaryRegion dictionaryRegion = new DictionaryRegion();
			dictionaryRegion.setUri(region_.getSpread().getURI());
			dictionaryRegion.setRegion(region);
			dictionary.addDictionaryRegionList(dictionaryRegion);
		}else{
			Dictionary dictionary = new Dictionary();
			dictionary.setWord(word);
			
			DictionaryRegion dictionaryRegion = new DictionaryRegion();
			dictionaryRegion.setUri(region_.getSpread().getURI());
			dictionaryRegion.setRegion(region);
			dictionary.addDictionaryRegionList(dictionaryRegion);
			
			dictionaryMap.put(word, dictionary);
		}
		Spread spread  = region.getSpread();
		spread.addRegion(region);
		spread.checkDscFile();
		spread.loadLines();
		// N쐬
		{
			GSExplanatoryNote note = new GSExplanatoryNote("<xml></xml>");
			GS_RWRepository.getInstance().createConnection(region_, region, note,Connection.TARGET_TO_SOURCE);
		}
		{
			GSExplanatoryNote note = new GSExplanatoryNote("<xml></xml>");
			GS_RWRepository.getInstance().createConnection(region, region_, note,Connection.TARGET_TO_SOURCE);
		}
		if(!loadSpreads.contains(spread)){
			loadSpreads.add(spread);
		}

	}
	
	protected Region createDSC(Region region){
		SpreadTree spreadTree = SpreadTree.getInstance();
		Image image = region.getSpread().getImage();
		
		String imagepath = Preference.getInstance().getImageFolderPath();
		imagepath = StringUtils.replace(imagepath, "\\", "/");
		if(!imagepath.endsWith("/")){
			imagepath += "/";
		}
		imagepath += DICTIONARY + "/";
		File file = new File(imagepath);
		if(!file.exists()){
			file.mkdirs();
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		Calendar cal = Calendar.getInstance();
		String filename = sdf.format(cal.getTime());
		try{
			String extend = "";
			if(region.getSpread().getFile().getName().lastIndexOf(".") != -1){
				extend = region.getSpread().getFile().getName().substring(region.getSpread().getFile().getName().lastIndexOf("."),region.getSpread().getFile().getName().length());
			}
			copyTransfer(region.getSpread().getFile().getAbsolutePath(),imagepath + sdf.format(cal.getTime()) + extend);
		}catch(IOException e){
			e.printStackTrace();
		}

		
		String folderPath = Spread.DSC_FOLDER_PATH; 
		folderPath = StringUtils.replace(folderPath, "\\", "/");
		if(!folderPath.endsWith("/")){
			folderPath+="/";
		}
		folderPath += DICTIONARY + "/";
		new File(folderPath).mkdirs();
		new BmpFileCreator(image,image.getWidth(null),image.getHeight(null)).create(folderPath,filename + ".bmp",false);

		List<LineSegment> segments = new ArrayList<LineSegment>();
		List<Point2D> points = new ArrayList<Point2D>();
		Rectangle rectangle = region.getView().getRectangle();
		
		points.add(new Point((int)rectangle.getX(),(int)rectangle.getY()));
		points.add(new Point((int)rectangle.getX() + (int)rectangle.getWidth(),(int)rectangle.getY()));
		points.add(new Point((int)rectangle.getX() + (int)rectangle.getWidth(),(int)rectangle.getY() + (int)rectangle.getHeight()));
		points.add(new Point((int)rectangle.getX(),(int)rectangle.getY() + (int)rectangle.getHeight()));
		segments.add(new LineSegment(null,points));
		SegmentInfoCreator creator = new SegmentInfoCreator();
		creator.createSegmentInfo(segments, folderPath,filename);
		
		File xmlfile = new File(folderPath+ filename + ".xml");
		creator.createDSCFile(xmlfile.getAbsolutePath(),false);
		
		spreadTree.clearSelection();
		AddDirectoryAction addDirectoryAction = new AddDirectoryAction(spreadTree.getRootSpreadDirectory().getFile(),spreadTree,spreadTree.getRootSpreadDirectory());
		addDirectoryAction.exec(file);
		
		DefaultMutableTreeNode rootNode = spreadTree.getRootNode();
		Enumeration enumeration = rootNode.children();
		while( enumeration.hasMoreElements() ){
            // evf擾܂B 
            Object obj = (Object)enumeration.nextElement();
            if(obj instanceof DefaultMutableTreeNode){
            	DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)obj;
            	if(childNode.toString().equals(DICTIONARY)){
            		Object pathArray[] = {rootNode,childNode};
            		spreadTree.setSelectionPath(new TreePath(pathArray));
            		break;
            	}
            }
		}

		Spread spread = spreadTree.getSpreadByURI2(DICTIONARY + "/" + filename);
		
		// 쐬t@C폜
		new File(folderPath,filename + ".bmp").delete();
		xmlfile.delete();
		
		return new Region(spread,new RectangleView(rectangle));
	}
	private void copyTransfer(String srcPath, String destPath) throws IOException {
	    FileChannel srcChannel = new  FileInputStream(srcPath).getChannel();
	    FileChannel destChannel = new FileOutputStream(destPath).getChannel();
	    try {
	        srcChannel.transferTo(0, srcChannel.size(), destChannel);
	    } finally {
	        srcChannel.close();
	        destChannel.close();
	    }
	}
	public void add(String word,Dictionary newDictionary){
		if(dictionaryMap.containsKey(word)){
			Dictionary dictionary = dictionaryMap.get(word);
			ArrayList<DictionaryRegion> list = newDictionary.getDictionaryRegionList();
			for(int i=0;i<list.size();i++){
				dictionary.addDictionaryRegionList(list.get(i));
			}
		}else{
			dictionaryMap.put(word, newDictionary);
		}
	}
	
	public void deleteRegion(String word,int index){
		if(dictionaryMap.containsKey(word)){
			Dictionary dictionary = dictionaryMap.get(word);
			DictionaryRegion dictionaryRegion = dictionary.getDictionaryRegionList(index);
			String deleteURL = dictionaryRegion.getRegion().getSpread().getURI();
			deleteTree(deleteURL);
		}
	}
	public void delete(String word){
		Dictionary dictionary = null;
		if(dictionaryMap.containsKey(word)){
			dictionary = dictionaryMap.get(word);
		}else{
			return;
		}
		ArrayList<DictionaryRegion> dictionaryRegionList = dictionary.getDictionaryRegionList();
		ArrayList<String> deleteUrlList = new ArrayList<String>();
        for(int i=0;i<dictionaryRegionList.size();i++){
        	DictionaryRegion dictionaryRegion = dictionaryRegionList.get(i);
        	deleteUrlList.add(dictionaryRegion.getRegion().getSpread().getURI());
        }
        for(int i=0;i<deleteUrlList.size();i++){
        	deleteTree(deleteUrlList.get(i));
        }
		
	}
	protected void deleteTree(String url){
		SpreadTree spreadTree = SpreadTree.getInstance();
		
		DefaultMutableTreeNode rootNode = spreadTree.getRootNode();
		Enumeration enumeration = rootNode.children();
		while( enumeration.hasMoreElements() ){
            // evf擾܂B 
            Object obj = (Object)enumeration.nextElement();
            if(obj instanceof DefaultMutableTreeNode){
            	DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)obj;
            	if(childNode.toString().equals(DICTIONARY)){
            		Enumeration enumeration2 = childNode.children();
            		while( enumeration2.hasMoreElements() ){
                        // evf擾܂B 
                        Object obj2 = (Object)enumeration2.nextElement();
                        if(obj2 instanceof DefaultMutableTreeNode){
                        	DefaultMutableTreeNode childNode2 = (DefaultMutableTreeNode)obj2;
                        	if(childNode2.getUserObject() instanceof Spread){
                        		Spread deleteSpread = (Spread)childNode2.getUserObject();
                            	if(deleteSpread.getURI().equals(url)){
                            		spreadTree.clearSelection();
                            		Object pathArray[] = {rootNode,childNode,childNode2};
            	            		spreadTree.setSelectionPath(new TreePath(pathArray));
            	            		spreadTree.remove();
            	            		return;
                            	}
                        	}
                        }
            		}
            	}
            }
		}
		
	}
	
	public void deleteByURL(String url){
		Iterator<String> itr = dictionaryMap.keySet().iterator();
		ArrayList<String> deleteWordList = new ArrayList<String>();
		while(itr.hasNext()){
			String word = itr.next();
			Dictionary dictionary = dictionaryMap.get(word);
			ArrayList<DictionaryRegion> dictionaryRegionList = dictionary.getDictionaryRegionList();
			while(true){
				int deleteIndex = -1;
				for(int i=0;i<dictionaryRegionList.size();i++){
					DictionaryRegion dictionaryRegion = dictionaryRegionList.get(i);
					Region region = dictionaryRegion.getRegion();
					if(region.getSpread().getURI().equals(url)){
						deleteIndex = i;
						break;
					}
				}
				if(deleteIndex != -1){
					dictionaryRegionList.remove(deleteIndex);
				}else{
					break;
				}
			}
			if(dictionaryRegionList.size() == 0){
				if(!deleteWordList.contains(word)){
					deleteWordList.add(word);
				}
			}
		}
		for(int i=0;i<deleteWordList.size();i++){
			String deleteWord = deleteWordList.get(i);
			if(dictionaryMap.containsKey(deleteWord)){
				dictionaryMap.remove(deleteWord);
			}
		}
	}

	public Dictionary getDictionary(String word){
		if(dictionaryMap.containsKey(word)){
			return dictionaryMap.get(word);
		}
		return null;
	}

	
	public synchronized void write() throws ParserConfigurationException{
		if(dictionaryfilename == null){
			// G[
			return;
		}
		// obNAbv.
		{
			File file = new File( dictionaryfilename );
			if(file.exists()){
				File renameFile = new File(dictionaryfilename + ".old" );
				if(renameFile.exists()){
					renameFile.delete();
				}
		        file.renameTo( new File(dictionaryfilename + ".old" ) ); 
			}
		}

		Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
		Element rootElement = document.createElement("dictionary");
		document.appendChild(rootElement);
		


		Iterator<String> itr = dictionaryMap.keySet().iterator();
		while(itr.hasNext()){
			String word = itr.next();

			Element indexElement = document.createElement("index");
			indexElement.setAttribute("word", word);
			
			Dictionary dictionary = dictionaryMap.get(word);
			ArrayList<DictionaryRegion> dictionaryRegionList = dictionary.getDictionaryRegionList();
			
			for(int i=0;i<dictionaryRegionList.size();i++){
				DictionaryRegion dictionaryRegion = dictionaryRegionList.get(i);
				Region region = dictionaryRegion.getRegion();
				Spread spread = region.getSpread();
				
				Element spreadElement = document.createElement("spread");
				spreadElement.setAttribute(GSResource.NAME, spread.getName());
				spreadElement.setAttribute(GSResource.URI, spread.getURI());
//				String filepath = spread.getFile().getAbsolutePath();
				String filepath = spread.getFile().getPath();
				this.isAbsolutePath(filepath, spreadElement);

				Element element = document.createElement("region");
				element.setAttribute(GSResource.NAME, region.getName());
				element.setAttribute(GSResource.URI, region.getURI());
				// kazuhiro kobayashi
				element.setAttribute("protection", region.isProtected());
				element.appendChild(region.getView().createXMLElement(document));
				spreadElement.appendChild(element);
				
				indexElement.appendChild(spreadElement);

			}
			rootElement.appendChild(indexElement);


		}
		
		// ŏo.
		
		TransformerFactory factory = TransformerFactory.newInstance();
		try {
			Transformer transformer = factory.newTransformer();
			transformer.setOutputProperty("encoding", "UTF-8");
			transformer.setOutputProperty("standalone", "yes");
			transformer.setOutputProperty("indent", "yes");
						
			DOMSource source = new DOMSource(document);
			File file = new File(dictionaryfilename);

			StringWriter output = new StringWriter();
			transformer.transform(source, new StreamResult(output));
			String string = output.toString();

			OutputStreamWriter writer = new OutputStreamWriter(
					new FileOutputStream(file), "UTF-8");

			writer.write(string);
			//
			transformer = null;
			file = null;
			// result = null;
			source = null;
			writer.close();
		} catch (TransformerConfigurationException e1) {
			e1.printStackTrace();
		} catch (TransformerException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		factory = null;
		// ݌ネ[h.
		// load();
		
	}

	private void isAbsolutePath(String filepath, Element element){
		String rootpath = Preference.getInstance().getSmart_gsFolderPath();
		if (filepath.startsWith(rootpath)) {
			/*
			 * "&"xml̃p[Tʂ"&amp;"ɕϊĂ܂肪łȂB
			 * ̂߁AXMLSaverNXŃt@CXML`̕ލۂɒuĂB
			 */
			element.setAttribute("filename", "&rootpath;"
					+ filepath.substring(rootpath.length()));
		} else {
			element.setAttribute("filename", filepath);
		}
	}

}
