package smart_gs.dictionary;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.xml.parsers.ParserConfigurationException;

import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.swingui.WorkspaceWindow;

import com.hexidec.ekit.component.JComboBoxNoFocus;

/**
 * _CAO
 * @author shimizu
 *
 */
public class DictionaryDialog extends JDialog {
	/**
	 * ʂ̕\.
	 */
	public static final int NUMBER_OF_PAGE = 5;
	/**
	 * g̃_CAO.
	 */
	protected JDialog myDialog;
	/**
	 * ݉ʕ\ĂPꃊXg.
	 */
	protected ArrayList<JTextField> textList = new ArrayList<JTextField>();
	/**
	 * ̑傫Xg.
	 */
	protected JComboBoxNoFocus jcmbFontSizeSelector;
	/**
	 * ʃpl.
	 */
	protected JPanel tablePanel;
	/**
	 * XN[pliʂ̃Cj.
	 */
	protected JScrollPane scrollpane;
	/**
	 * ENbNj[
	 */
	protected JPopupMenu popup;
	/**
	 * ENbN-폜.
	 */
	protected JMenuItem deleteProperty;
	/**
	 * ENbN-E.
	 */
	protected JMenuItem rightProperty;
	/**
	 * ENbN-.
	 */
	protected JMenuItem leftProperty;

	/**
	 * ^Cv
	 * 0 - ʏ
	 * 1 - PI
	 */
	protected int process_type = 0;
	/**
	 * tB[h.
	 */
	protected JTextField searchField;

	/**
	 * x.
	 */
	protected JLabel items;
	/**
	 * ֌{^.
	 */
	protected JButton nextSearch;
	/**
	 * O֌{^.
	 */
	protected JButton previousSearch;
	/**
	 * ݂̌Jnʒu.
	 */
	protected int presentPage = 0;
	
	/**
	 * ɂđIĂP.
	 */
	protected String choiceword = "";
	/**
	 * ɂđIĂ摜ԍ.
	 */
	protected int choiceindex;
	/**
	 * ^Cv-1ɃLZꂽۂ.
	 */
	protected boolean cancel = false;
	/**
	 * K\
	 */
	protected JCheckBox caseSensitiveBox;
	/**
	 * 啶
	 */
	protected JCheckBox regularExpressionsBox;

	/**
	 * RXgN^.
	 * @param frame
	 * @param title
	 * @param modal
	 * @param process_type
	 */
	public DictionaryDialog(Frame frame, String title, boolean modal,int process_type) {
		super(frame, title, modal);
		// ^Cv
		this.process_type = process_type;
		this.setSize(800, 600); // t[̏TCY
		this.setLocationRelativeTo(null); // t[ʂ̒ɕ\
		this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE); // _CAOŁuvIĂȀԂۂ
		this.addWindowListener(new WindowClosing());
		// this.setJMenuBar(setMenu()); // j[o[̏܂Ƃ߂

		// ENbNj[쐬
		popup = new JPopupMenu();
		deleteProperty = new JMenuItem("Delete");
		deleteProperty.addActionListener(new DeleteListener());
		rightProperty = new JMenuItem("Move to the Right");
		rightProperty.addActionListener(new RightMovedAction());
		leftProperty = new JMenuItem("Move to the Left");
		leftProperty.addActionListener(new LeftMovedAction());
		popup.add(deleteProperty);
		popup.add(rightProperty);
		popup.add(leftProperty);
		
		Panel toolBarPanel = new Panel();
		toolBarPanel.setLayout(new BorderLayout());
		toolBarPanel.add(getJToolBar(),BorderLayout.NORTH);
		toolBarPanel.add(getJToolBar2(),BorderLayout.SOUTH);
		
		this.add(toolBarPanel, BorderLayout.NORTH);
		
		
		// Ώۂ0Ԗ-null
		presentPage = 0;
		tablePanel = getTable(presentPage,null);
		setResultPanel(tablePanel,false);
		// gNXϐɓo^.
		this.myDialog = this;
		
	}
	/**
	 * j[o[쐬.
	 * @return
	 */
	public JToolBar getJToolBar(){
		JToolBar jtlbar = new JToolBar();
		// ֏
		nextSearch = new JButton(">>");
		nextSearch.addActionListener(
				new ActionListener(){
					public void actionPerformed(ActionEvent e){
						presentPage+=NUMBER_OF_PAGE;
						research(false);
					}
				}
		);
		// x
		items = new JLabel();
		
		// O֏
		previousSearch = new JButton("<<");
		previousSearch.addActionListener(
				new ActionListener(){
					public void actionPerformed(ActionEvent e){
						presentPage-=NUMBER_OF_PAGE;
						research(false);
					}
				}
		);
		// {^
		JButton jbtnSearch = new JButton("Search");
		jbtnSearch.addActionListener(
				new ActionListener(){
					public void actionPerformed(ActionEvent e){
						presentPage=0;
						research(false);
					}
				}
		);
		// P̓tB[h
		searchField = new JTextField();
		searchField.addKeyListener(new KeyListener(){
			// EnterL[łł悤ɑΉ.
			public void keyPressed(KeyEvent e) {
				int keycode = e.getKeyCode();
				if (keycode == KeyEvent.VK_ENTER){
					presentPage=0;
					research(false);
				}				
			}

			public void keyReleased(KeyEvent e) {
				
			}

			public void keyTyped(KeyEvent e) {
				
			}
			
		});
		// ̑傫I
		jcmbFontSizeSelector = new JComboBoxNoFocus((new String[] { "8", "10",
				"12", "14", "18", "24", "32" }));
		jcmbFontSizeSelector.setMaximumSize(jcmbFontSizeSelector
				.getPreferredSize());
		jcmbFontSizeSelector.setSelectedIndex(4);
		jcmbFontSizeSelector.addActionListener(
			new ActionListener(){
				// ̑傫ύXꂽꍇAׂTextFiledɑ΂čs.
				public void actionPerformed(ActionEvent e){
					for(int i=0;i<textList.size();i++){
						JTextField textField = textList.get(i);
						String sizeStr = (String)jcmbFontSizeSelector.getSelectedItem();
						textField.setFont(new Font("Serif",Font.PLAIN, Integer.parseInt(sizeStr)));
						tablePanel.updateUI();
					}
				}
			}
		);

		// c[o[o^.
		jtlbar.add(previousSearch);
		jtlbar.add(items);
		jtlbar.add(nextSearch);
		jtlbar.add(searchField);
		jtlbar.add(jbtnSearch);
		jtlbar.addSeparator(); // Zp[^ǉ
		jtlbar.add(jcmbFontSizeSelector);
	
		return jtlbar;
	}
	/**
	 * c[o[i
	 * @return
	 */
	public JToolBar getJToolBar2(){
		JToolBar jtlbar = new JToolBar();
		caseSensitiveBox = new JCheckBox("Case sensitive");
		regularExpressionsBox = new JCheckBox("Regular expressions");
		jtlbar.add(caseSensitiveBox);
		jtlbar.add(regularExpressionsBox);
		return jtlbar;

	}
	/**
	 * ʂ𔽉f.
	 * @param jPanel
	 * @param scroll true XN[o[ێ,false XN[o[ێȂ.
	 */
	public void setResultPanel(JPanel jPanel,boolean scroll){
		Point point = null;
		if(scrollpane != null){
			// XN[o[ێꍇÃ݂XN[o[x擾
			// č쐬ɔf
			if(scroll){
				JViewport view = scrollpane.getViewport();
				Point viewPosition  = view.getViewPosition();
				point = new Point();
				point.setLocation(viewPosition.getX(), viewPosition.getY());
			}
			// ݂̌ʂxj
			this.remove(scrollpane);
		}
		// ēxʂ쐬
		scrollpane = new JScrollPane(jPanel);
	    scrollpane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
	    scrollpane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
	    // XN[o[̈ێsꍇ͑O̐ݒĐݒ
	    if(point != null){
	    	JViewport view = scrollpane.getViewport();
			view.setViewPosition(point);
	    }
	    this.add(scrollpane, BorderLayout.CENTER);
	    // ȉĂ΂ȂƉʂĕ`悳Ȃ
	    this.invalidate();
	    this.validate();
	}
	/**
	 * ʂ쐬.
	 * @param start
	 * @param searchword
	 * @return
	 */
	public JPanel getTable(int start,String searchword){
		// xo^ĂAPꃊXgj
		textList.clear();
		TreeMap<String, Dictionary> dictionaryMap = null;
		if(searchword == null){
			searchword = "";
		}
		// ݒ肳Ăꍇ͑Ώ擾AĂȂꍇׂĎ擾
		if(searchword.equals("")){
			DictionaryXML dictionaryXML = DictionaryXML.getInstance();
			dictionaryMap = dictionaryXML.getDictionaryMap();
		}else{
			if(!caseSensitiveBox.isSelected()){
				searchword = searchword.toLowerCase();
			}
			if(regularExpressionsBox.isSelected()){
				DictionaryXML dictionaryXML = DictionaryXML.getInstance();
				dictionaryMap = dictionaryXML.getDictionaryMapByregularExpressions(searchword);
			}else{
				DictionaryXML dictionaryXML = DictionaryXML.getInstance();
				dictionaryMap = dictionaryXML.getDictionaryMap(searchword);
			}
		}
		int maximage = 0;
		
		// x[XƂȂpl[GridBagLayout]Ƃč쐬
		GridBagLayout layout = new GridBagLayout();
		JPanel panelBase = new JPanel();
		panelBase.setLayout(layout);
		
		
		// Jnʒu0AÕ{^񊈐ɂ.
		if(start == 0){
			previousSearch.setEnabled(false);
		}else{
			previousSearch.setEnabled(true);
		}
		
		// Iʒustart + NUMBER_OF_PAGE傫ꍇփ{^񊈐ɂ.
		if(start + NUMBER_OF_PAGE >= dictionaryMap.size()){
			nextSearch.setEnabled(false);
		}else{
			nextSearch.setEnabled(true);
		}
		
		// ݒ
		int star_label = start;
		if(star_label != 0){
			star_label = star_label / NUMBER_OF_PAGE;
		}
		items.setText(star_label + 1 + "[" + (start + 1) + "-" + (start + NUMBER_OF_PAGE) + "]" + "/" + ((int)Math.ceil((double)dictionaryMap.size() / NUMBER_OF_PAGE)) +"[" + dictionaryMap.size() + "]");

		// tHgTCY
		int fontsize = 18;
		try{
			fontsize = Integer.parseInt((String)jcmbFontSizeSelector.getSelectedItem());
		}catch(Exception e){}

		
		Iterator<String> itr  = null;
		// J̍őlvZ.
		int i=0;
		int counter = -1;
		itr = dictionaryMap.keySet().iterator();
		while(itr.hasNext()){
			counter++;
			String word = itr.next();
			if(counter < start){
				continue;
			}
			// y2̂ŋKl * 2ŌvZ.
			if((NUMBER_OF_PAGE * 2) <= i){
				break;
			}
			Dictionary dictionary = dictionaryMap.get(word);
			ArrayList<DictionaryRegion> list = dictionary.getDictionaryRegionList();
			if(maximage < list.size()){
				maximage = list.size();
			}
			i+=2;
		}
		// ēx擾Ae[u쐬.
		itr = dictionaryMap.keySet().iterator();
		i=0;
		counter = -1;
		while(itr.hasNext()){
			counter++;
			String word = itr.next();
			if(counter < start){
				continue;
			}
			// y2̂ŋKl * 2ŌvZ.
			if((NUMBER_OF_PAGE * 2) <= i){
				break;
			}
			JTextField textField = new JTextField(word,20);
			textField.setToolTipText(word);
			textField.setFont(new Font("Serif",Font.PLAIN, fontsize));
			textField.addFocusListener(new TextFieldFocusListener(textField));
			
			GridBagLayout wordlayout = new GridBagLayout();
			JPanel wordpanel = new JPanel();
			wordpanel.setLayout(wordlayout);
			wordpanel.setBorder(new LineBorder(Color.BLACK));
			wordpanel.setBackground(Color.WHITE);
//			wordpanel.setLayout(new BorderLayout());

			GridBagConstraints wordgbc = new GridBagConstraints();
			wordgbc.gridx = 0;
			wordgbc.gridy = 0;
			wordgbc.fill = GridBagConstraints.BOTH;
			wordgbc.insets = new Insets(10, 10, 10, 10);
			wordlayout.setConstraints(textField, wordgbc);
			
			wordpanel.add(textField);
			
			// ʏ̏ꍇ͍폜{^zu
			if(process_type == 0){
				JButton button = new JButton("delete");
				button.addActionListener(new DictonaryTextDeleteListener(word));
				Dimension size = new Dimension(100, 20);
				button.setMaximumSize(size);
				button.setMinimumSize(size);
				button.setPreferredSize(size);
				JPanel buttonpanel = new JPanel();
				buttonpanel.setBorder(new LineBorder(Color.WHITE));
				buttonpanel.setBackground(Color.WHITE);
				buttonpanel.add(button);
				
				wordgbc.gridx = 0;
				wordgbc.gridy = 1;
				wordgbc.fill = GridBagConstraints.BOTH;
				wordgbc.insets = new Insets(10, 10, 10, 10);
				wordlayout.setConstraints(buttonpanel, wordgbc);
				wordpanel.add(buttonpanel);
			// PȈꍇ͑I{^zu
			}else if(process_type == 1){
				JButton button = new JButton("choice");
				button.addActionListener(new SelectWordAction(word));
				Dimension size = new Dimension(100, 20);
				button.setMaximumSize(size);
				button.setMinimumSize(size);
				button.setPreferredSize(size);
				JPanel buttonpanel = new JPanel();
				buttonpanel.setBorder(new LineBorder(Color.WHITE));
				buttonpanel.setBackground(Color.WHITE);
				buttonpanel.add(button);
				wordgbc.gridx = 0;
				wordgbc.gridy = 1;
				wordgbc.fill = GridBagConstraints.BOTH;
				wordgbc.insets = new Insets(10, 10, 10, 10);
				wordlayout.setConstraints(buttonpanel, wordgbc);
				wordpanel.add(buttonpanel);
			}
			// PꃊXgɓo^
			textList.add(textField);
			GridBagConstraints gbc = new GridBagConstraints();
			gbc.fill = GridBagConstraints.BOTH;
			gbc.weightx = 100.0;
			gbc.weighty = 100.0;
	
			gbc.gridx = 0;
			gbc.gridy = i;
			gbc.gridwidth = 1;
			gbc.gridheight = 2;	// cQ

			layout.setConstraints(wordpanel, gbc);
			
			// zu.
			panelBase.add(wordpanel);

			Dictionary dictionary = dictionaryMap.get(word);
			ArrayList<DictionaryRegion> dictionaryList = dictionary.getDictionaryRegionList();
			for(int j=0;j<maximage;j++){
				JPanel labelPanel = new JPanel();
				labelPanel.setBorder(new LineBorder(Color.BLACK));
				labelPanel.setBackground(Color.WHITE);
				if(dictionaryList.size() > j){
					DictionaryRegion dictionaryRegion = dictionaryList.get(j);
					Region region = dictionaryRegion.getRegion();
					Spread spread = region.getSpread();
					labelPanel.add(new JLabel(spread.getURI()));
				}
				
				JPanel imagePanel = new JPanel();
				imagePanel.setBorder(new LineBorder(Color.BLACK));
				imagePanel.setBackground(Color.WHITE);
				if(dictionaryList.size() > j){
					DictionaryRegion dictionaryRegion = dictionaryList.get(j);
					Region region = dictionaryRegion.getRegion();
					try {
						JPanel regionJPanel = region.createElementViewPanel(); 
						regionJPanel.addMouseListener(new RegionMouseListener(word,j,region));
						imagePanel.add(regionJPanel);
					} catch (NoWayToShowException e) {
						// TODO ꂽ catch ubN
						e.printStackTrace();
					}				
				}
				gbc.gridx = j + 1;
				gbc.gridy = i;
				gbc.gridwidth = 1;
				gbc.gridheight = 1;

				layout.setConstraints(labelPanel, gbc);
					
				gbc.gridx = j + 1;
				gbc.gridy = i+1;
				gbc.gridwidth = 1;
				gbc.gridheight = 1;
				layout.setConstraints(imagePanel, gbc);
				
				panelBase.add(labelPanel);
				panelBase.add(imagePanel);
			}
			i+=2;
		}
		return panelBase;
	}
	/***
	 * Č
	 * @param scroll
	 */
	public void research(boolean scroll){
		if(scrollpane != null){
			scrollpane.remove(tablePanel);
		}
		tablePanel.removeAll();
		tablePanel = getTable(presentPage,searchField.getText());
		setResultPanel(tablePanel,scroll);
	}
	/**
	 * LZꂽۂ
	 * @return
	 */
	public boolean isCancel() {
		return cancel;
	}
	/**
	 * PȊIꂽP
	 * @return
	 */
	public String getCchoiceWord(){
		return choiceword;
	}
	
	public void search(String text,boolean isRegularExpressions,boolean isCaseSensitive){
		this.searchField.setText(text);
		regularExpressionsBox.setSelected(isRegularExpressions);
		caseSensitiveBox.setSelected(isCaseSensitive);
		presentPage=0;
		research(false);
	}
	

	/**
	 * Windowś~ꂽ̏. 
	 *
	 */
	class WindowClosing extends WindowAdapter {
		public void windowClosing(WindowEvent e) {
			myDialog.setVisible(false);
			cancel = true;
		}
	}

	class RegionMouseListener implements MouseListener{
		private GS_RWElement element;
		private String word;
		private int index;
		public RegionMouseListener(String word,int index,GS_RWElement element){
			this.element = element;
			this.word = word;
			this.index = index;
		}
		
		public void mouseClicked(MouseEvent e) {
			if(SwingUtilities.isRightMouseButton(e)){
				choiceindex = index;
				choiceword = word;
				DictionaryXML dictionaryXML = DictionaryXML.getInstance();
				TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
				Dictionary dictionary = dictionaryMap.get(word);
				ArrayList<DictionaryRegion> regionList = dictionary.getDictionaryRegionList();
				if(index == 0){
					leftProperty.setVisible(false);
				}else{
					leftProperty.setVisible(true);
				}
				if(regionList.size() > (index + 1)){
					rightProperty.setVisible(true);
				}else{
					rightProperty.setVisible(false);
				}
				popup.show(e.getComponent(), e.getX(), e.getY());
			}else{
				element.show();
			}
		}

		public void mouseEntered(MouseEvent e) {
			
		}

		public void mouseExited(MouseEvent e) {
			
		}

		public void mousePressed(MouseEvent e) {
			
		}

		public void mouseReleased(MouseEvent e) {
			
		}
		
	}
	class DictonaryTextDeleteListener implements ActionListener{
		protected String word;
		
		public DictonaryTextDeleteListener(String word){
			this.word = word;
		}
		
		public void actionPerformed(ActionEvent e) {
			int value = JOptionPane.showConfirmDialog(WorkspaceWindow.getInstance() , "Do you delete word ?",	"Confirmation" , JOptionPane.YES_NO_OPTION);
			if (value != JOptionPane.YES_OPTION){
				return;
			}
			DictionaryXML dictionaryXML = DictionaryXML.getInstance();
			dictionaryXML.delete(word);
			try {
				dictionaryXML.write();
				dictionaryXML.load();
				TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
				if(dictionaryMap.size() != 0){
					if(dictionaryMap.size() % NUMBER_OF_PAGE ==  0){
						presentPage-=NUMBER_OF_PAGE;
					}
				}
				
				research(true); 
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			}
		}

	}
	class TextFieldFocusListener implements FocusListener{
		protected JTextField textField;
		protected String temp;
		public TextFieldFocusListener(JTextField textField){
			this.textField = textField;
		}
		public void focusGained(FocusEvent e) {
			temp = textField.getText();
		}

		public void focusLost(FocusEvent e) {
			String temp_ = textField.getText();
			if(!temp_.equals(temp)){
				DictionaryXML dictionaryXML = DictionaryXML.getInstance();
				Dictionary dictionary = dictionaryXML.getDictionary(temp);
				if(dictionary != null){
					dictionaryXML.delete(temp);
					dictionary.setWord(temp_);
					dictionaryXML.add(temp_, dictionary);
					try {
						dictionaryXML.write();
						dictionaryXML.load();
						research(false);
					} catch (ParserConfigurationException e1) {
						e1.printStackTrace();
					}
				}
			}
		}
		
	}
	
	class RightMovedAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
			DictionaryXML dictionaryXML = DictionaryXML.getInstance();
			TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
			Dictionary dictionary = dictionaryMap.get(choiceword);
			ArrayList<DictionaryRegion> regionList = dictionary.getDictionaryRegionList();
			
			DictionaryRegion dictionaryRegion = regionList.remove(choiceindex);
			regionList.add(choiceindex + 1,dictionaryRegion);
			try {
				dictionaryXML.write();
				dictionaryXML.load();
				research(true);
				for(int i=0;i<textList.size();i++){
					JTextField textField = textList.get(i);
					if(textField.getText().equals(choiceword)){
						textField.requestFocus();
						break;
					}
				}
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			}
		}
	}
	class LeftMovedAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
			DictionaryXML dictionaryXML = DictionaryXML.getInstance();
			TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
			Dictionary dictionary = dictionaryMap.get(choiceword);
			ArrayList<DictionaryRegion> regionList = dictionary.getDictionaryRegionList();
			
			DictionaryRegion dictionaryRegion = regionList.remove(choiceindex);
			regionList.add(choiceindex - 1,dictionaryRegion);
			try {
				dictionaryXML.write();
				dictionaryXML.load();
				research(true);
				for(int i=0;i<textList.size();i++){
					JTextField textField = textList.get(i);
					if(textField.getText().equals(choiceword)){
						textField.requestFocus();
						break;
					}
				}
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			}
		}
	}
	
	class SelectWordAction implements ActionListener{
		protected String word;
		public SelectWordAction(String word){
			this.word = word;
		}
		public void actionPerformed(ActionEvent e) {
			choiceword = word;
			myDialog.setVisible(false);
		}
		
	}
	class DeleteListener implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			DictionaryXML dictionaryXML = DictionaryXML.getInstance();
			dictionaryXML.deleteRegion(choiceword, choiceindex);
			try {
				dictionaryXML.write();
				dictionaryXML.load();
				TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
				if(dictionaryMap.size() != 0){
					if(dictionaryMap.size() % NUMBER_OF_PAGE ==  0){
						presentPage-=NUMBER_OF_PAGE;
					}
				}
				
				research(true);
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			}
		}

	}
	class ColorLabel extends JLabel {
		ColorLabel() {
			setBackground(Color.WHITE);
			setOpaque(true);
			setBorder(BorderFactory.createLineBorder(Color.BLACK,2));
		}
	}

}