package webdav.table;
//-*- mode:java; encoding:utf8n; coding:utf-8 -*-
// vim:set fileencoding=utf-8:
//http://terai.xrea.jp/Swing/ExplorerLikeTable.html
import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;

public class PropFindRenderer extends Box implements TableCellRenderer {
    private static final Border noFocusBorder = BorderFactory.createEmptyBorder(1,1,1,1);
    private final ImageIcon foldericon1;
    private final ImageIcon foldericon2;
    private final ImageIcon file1icon1;
    private final ImageIcon file1icon2;
    private final ImageIcon file2icon1;
    private final ImageIcon file2icon2;
    
    private final ImageIcon nicon;
    private final ImageIcon sicon;
    //private final DotLabel textLabel;
    private final JLabel textLabel;
    private final JLabel iconLabel;

    public PropFindRenderer(JTable table) {
        super(BoxLayout.X_AXIS);
        //textLabel = new DotLabel(new Color(~table.getSelectionBackground().getRGB()));
        textLabel = new JLabel("dummy");
        textLabel.setOpaque(true);
        textLabel.setBorder(noFocusBorder);
        nicon = new ImageIcon(getClass().getResource("folder.png"));
        {
	        foldericon1 = new ImageIcon(getClass().getResource("folder.png"));
	        FilteredImageSource fis = new FilteredImageSource(foldericon1.getImage().getSource(), new SelectedImageFilter());
	        foldericon2 = new ImageIcon(createImage(fis));
        }
        {
	        file1icon1 = new ImageIcon(getClass().getResource("file.png"));
	        FilteredImageSource fis = new FilteredImageSource(file1icon1.getImage().getSource(), new SelectedImageFilter());
	        file1icon2 = new ImageIcon(createImage(fis));
        }
        {
	        file2icon1 = new ImageIcon(getClass().getResource("file_alert.png"));
	        FilteredImageSource fis = new FilteredImageSource(file2icon1.getImage().getSource(), new SelectedImageFilter());
	        file2icon2 = new ImageIcon(createImage(fis));
        }
        
        FilteredImageSource fis = new FilteredImageSource(nicon.getImage().getSource(), new SelectedImageFilter());
        sicon = new ImageIcon(createImage(fis));
        iconLabel = new JLabel(nicon);
        iconLabel.setBorder(BorderFactory.createEmptyBorder());
        table.setRowHeight(Math.max(textLabel.getPreferredSize().height,
                                    iconLabel.getPreferredSize().height));
        add(iconLabel);
        add(textLabel);
        add(Box.createHorizontalGlue());
    }
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        textLabel.setText(value==null?"":value.toString());
        FontMetrics fm = table.getFontMetrics(table.getFont());
        int swidth = fm.stringWidth(textLabel.getText()) + textLabel.getInsets().left + textLabel.getInsets().right;
        int cwidth = table.getColumnModel().getColumn(column).getWidth()-iconLabel.getPreferredSize().width;
        textLabel.setPreferredSize(new Dimension(swidth>cwidth?cwidth:swidth,0)); //height:0 is dummy
        if(isSelected) {
            textLabel.setForeground(table.getSelectionForeground());
            textLabel.setBackground(table.getSelectionBackground());
        }else{
            textLabel.setForeground(table.getForeground());
            textLabel.setBackground(table.getBackground());
        }
        if(hasFocus) {
            textLabel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        }else{
            textLabel.setBorder(noFocusBorder);
        }
        //textLabel.setFocusedBorder(hasFocus);
        textLabel.setFont(table.getFont());
        String size = (String)table.getValueAt(row, 3);
        String lock = (String)table.getValueAt(row, 4);
        if(size.equals("")){
            iconLabel.setIcon(isSelected?foldericon2:foldericon1);
        }else{
        	if(lock.equals("")){
                iconLabel.setIcon(isSelected?file1icon2:file1icon1);
        	}else{
                iconLabel.setIcon(isSelected?file2icon2:file2icon1);
        	}
        }
        return this;
    }
    private static class SelectedImageFilter extends RGBImageFilter {
        public SelectedImageFilter() {
            canFilterIndexColorModel = true;
        }
        public int filterRGB(int x, int y, int argb) {
            Color color = new Color(argb,true);
            float[] array = new float[4];
            color.getComponents(array);
            return new Color(array[0]*0.5f, array[1]*0.5f, array[2], array[3]).getRGB();
        }
    }
}
// class DotLabel extends JLabel {
//     private final Border dotBorder;
//     private final Border empBorder = BorderFactory.createEmptyBorder(2,2,2,2);
//     public DotLabel(Color color) {
//         super("dummy");
//         dotBorder = new DotBorder(color,2);
//         setOpaque(true);
//         setBorder(empBorder);
//         //setFocusable(true);
//     }
//     private boolean focusflag = false;
//     public boolean isFocusedBorder() {
//         return focusflag;
//     }
//     public void setFocusedBorder(boolean flag) {
//         setBorder(flag?dotBorder:empBorder);
//         focusflag = flag;
//     }
//     private class DotBorder extends LineBorder {
//         public boolean isBorderOpaque() {return true;}
//         public DotBorder(Color color, int thickness) {
//             super(color, thickness);
//         }
//         @Override
//         public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
//             Graphics2D g2 = (Graphics2D)g;
//             g2.translate(x,y);
//             if(isFocusedBorder()) {
//                 g2.setPaint(getLineColor());
//                 javax.swing.plaf.basic.BasicGraphicsUtils.drawDashedRect(g2, 0, 0, w, h);
//             }
//             g2.translate(-x,-y);
//         }
//     }
// }
