package smart_gs.drawing_tool.drawing_mode;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;


import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.SpreadCanvas;
//import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.FreeLineView;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.logical.LineSegment;
import smart_gs.logical.region.FreeLineRegion;
import smart_gs.swingui.GSMouseEvent;

public class FreeLineMode extends DrawingModeAdapter{
	
	private static Mode singleton = new FreeLineMode();
	
	private Point2D start;
	private Point2D end;

	private List<Point2D> points;
	
	private Point2D tempStart;
	private Point2D tempEnd;
	private List<Point2D> tempPoints;
	private List<ExLine2D> lines;
	
	private FreeLineMode() {
		this.lines = new ArrayList<ExLine2D>();
		this.points = new ArrayList<Point2D>();
		this.tempPoints = new ArrayList<Point2D>();
	}
	public static Mode getInstance(){
		return singleton;
	}
	@Override
	public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
		super.mousePressed(e, canvas);

		if(this.start == null){
			this.start = e.getPoint();
			this.tempStart = e.getOriginalPoint();
			this.points.add(this.start);
			this.tempPoints.add(this.tempStart);
			return;
		}
		this.end = e.getPoint();
		this.tempEnd = e.getOriginalPoint();
		
		this.lines.add(new ExLine2D(start,end));
//		this.lines.add(new ExLine2D(tempStart,tempEnd));
		this.points.add(this.end);
		this.tempPoints.add(this.tempEnd);
		this.start = this.end;
		this.tempStart = this.tempEnd;
	}
	@Override
	public void mouseClicked(GSMouseEvent e,SpreadCanvas canvas) {
		super.mouseClicked(e,canvas);

		if(e.getClickCount() == 2){
			canvas.getSpread().addRegion(new FreeLineRegion(canvas.getSpread(),this.points));
			this.lines = new ArrayList<ExLine2D>();
			this.points = new ArrayList<Point2D>();
			this.tempPoints = new ArrayList<Point2D>();
			this.start = null;
			this.end = null;
			this.tempStart = null;
			this.tempEnd = null;
//			DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
			DefaultState.getInstance().setMode(FreeLineMode.getInstance());
			return;
		}
	}
	@Override
	public void mouseMoved(GSMouseEvent e,SpreadCanvas canvas) {
		super.mouseMoved(e,canvas);
		this.end = e.getPoint();
		this.tempEnd = e.getOriginalPoint();
	}
	/*
	@Override
	
	public void mouseDragged(GSMouseEvent e,SpreadCanvas canvas) {
		super.mouseDragged(e,canvas);
		this.end = e.getPoint();
		this.tempEnd = e.getOriginalPoint();
		this.lines.add(new ExLine2D(tempStart,tempEnd));
		this.points.add(this.end);
		this.tempPoints.add(this.tempEnd);
		this.start = this.end;
		this.tempStart = this.tempEnd;
	}
	*/
	@Override
	public void paint(Graphics g,SpreadCanvas canvas) {
		super.paint(g,canvas);
//		if(this.tempStart == null || this.tempEnd == null){
//			return ;
//		}
//		for(int i=0;i<this.lines.size();i++){
//			ExLine2D line = this.lines.get(i);
//			new LineView(line).draw((Graphics2D)g);
//		}
//
//		new LineView(new ExLine2D(tempStart,tempEnd)).draw((Graphics2D)g);
//		
		if(this.start == null || this.end == null){
			return ;
		}
		double ratio = canvas.getImageLabel().getRatio();
		double gapX = canvas.getImageLabel().getGapWidth();
		double gapY = canvas.getImageLabel().getGapHeight();
		for(int i=0;i<this.lines.size();i++){
			ExLine2D line = this.lines.get(i);
			new LineView(line).enlargedView(ratio,gapX,gapY).draw((Graphics2D)g);
		}

		new LineView(new ExLine2D(start,end)).enlargedView(ratio,gapX,gapY).draw((Graphics2D)g);
		
	}
}
