package smart_gs.dictionary.viewer;

import java.awt.Image;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import smart_gs.image_search.logical.GSQuery;
import smart_gs.logical.Region;
import smart_gs.util.ImageCropper;

@SuppressWarnings("serial")
public class QueryPanel extends JPanel{
	
	private Image image;
	
	public QueryPanel(Image image){
		this.image = image;
		this.buildGUI();
	}
	public QueryPanel(GSQuery query){
		this.image = query.getQueryImage();
		this.buildGUI();
	}
	public QueryPanel(Region region){
		ImageCropper cropper = new ImageCropper(region);
		this.image = cropper.crop();
		this.buildGUI();
	}
	private void buildGUI(){
		JPanel panel = new JPanel();
		JLabel label = new JLabel(new ImageIcon(this.image));
		panel.add(label);
		panel.setBorder(new TitledBorder("Query Image"));
		this.add(panel);
	}
}
