package com.hexidec.ekit;

import java.util.ArrayList;

public class GSHTMLUndoManager {
	protected int counter = 0;
	protected int maxundo = 100;
	protected boolean undoflg = false;
	protected ArrayList<UndoSet> undoList = new ArrayList<UndoSet>();
	public GSHTMLUndoManager(){
		
	}
	public GSHTMLUndoManager(int maxundo){
		this.maxundo = maxundo;
	}
	
	public void add(String source, int position){
		String sourceBody = getBody(source);
		if(undoList.size() != 0){
			String oldsource =  undoList.get(undoList.size() - 1).getSource();
			
			String oldsourceBody = oldsource;//getBody(oldsource);
			if(oldsourceBody.equals(sourceBody)){
				return;
			}
			/*
			if(oldsourceBody.length() == sourceBody.length()){
				return;
			}
			*/
			if(oldsource.equals(source)){
				return;
			}
		}
		if(counter >= 0){
			if(undoList.size() <= counter){
				counter = undoList.size() - 1;
			}
			if((undoList.size() - 1) != counter ){
				ArrayList<UndoSet> temp = new ArrayList<UndoSet>();
				for(int i=0;i<=counter;i++){
					temp.add(undoList.get(i));
				}
				undoList = temp;
			}
		}else{
			if(undoflg){
				undoList.clear();
			}
		}
		if(undoList.size() >= maxundo){
			undoList.remove(0);
		}
		UndoSet undoSet = new UndoSet();
		undoSet.setPosition(position);
		undoSet.setSource(sourceBody);
		undoList.add(undoSet);
		counter = undoList.size() - 1;
		undoflg = false;
	}
	public String getOldsource(){
		if(undoList.size() != 0){
			String oldsource =  undoList.get(undoList.size() - 1).getSource();
			return oldsource;
		}	
		return null;
	}
	public UndoSet undo(){
		undoflg = true;
		if(undoList.size() <= counter){
			counter = undoList.size() - 1;
		}
		if(1 > counter){
			return null;
		}
		UndoSet source = undoList.get(counter-1);
		counter--;
		return source;
	}
	public UndoSet redo(){
		counter++;
		if(counter < 0){
			counter = 1;
		}
		if(undoList.size() <= counter){
			return null;
		}
		UndoSet source = undoList.get(counter);
		return source;
	}

	public boolean canUndo(){
		if(0 > counter){
			return false;
		}
		if(undoList.size() <= counter){
			return false;
		}
		return true;
	}
	
	public boolean isUndo(){
		if(undoflg){
			undoflg = false;
			return true;
		}
		return false;
	}
	public String getBody(String source){
		String docTextCase = source;
		String containingTag = "body"; 
		int tagStart       = docTextCase.indexOf("<" + containingTag.toLowerCase());
		int tagStartClose  = docTextCase.indexOf(">", tagStart) + 1;
		String closeTag    = "</" + containingTag.toLowerCase() + ">";
		int tagEndOpen     = docTextCase.indexOf(closeTag);
		if(tagStartClose < 0) { tagStartClose = 0; }
		if(tagEndOpen < 0 || tagEndOpen > docTextCase.length()) { tagEndOpen = docTextCase.length(); }
		String bodyText;
		bodyText = source.substring(tagStartClose, tagEndOpen);
		bodyText = bodyText.replaceAll("\r", "");
		bodyText = bodyText.replaceAll("\n", "");
		bodyText = bodyText.replaceAll("\r\n", "");
		return bodyText.trim();
	}
}
