package webdav;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import smart_gs.GSConstants;
import smart_gs.logical.Preference;
import smart_gs.swingui.WorkspaceWindow;

public class WebDavListenerAction {

	
	public void open(){
		WorkspaceWindow window = WorkspaceWindow.getInstance();
		Preference preference = Preference.getInstance().getInstance();
		WebDavDownLoadEvent oldWebDavDownLoadEvent = WorkspaceWindow.getInstance().getWebDavDownLoadEvent();
		String owner = preference.getUserName();
		if(owner == null){
			owner = "";
		}
		if(owner.equals("")){
			owner = "unknown user";
		}
		Stack stack = null;
		String startpath = null;
		if(oldWebDavDownLoadEvent != null){
			Stack stack_ = oldWebDavDownLoadEvent.getStack();
			if(stack_ != null){
				if(stack_.size() != 0){
					stack = new Stack();
					// X^bN̓Rs[
					for(int i=0;i<stack_.size();i++){
						stack.add(stack_.get(i));
					}
					
				}
			}
			startpath = oldWebDavDownLoadEvent.getDownloadpath();
		}
		WebDavChooser webDavChooser = new WebDavChooser(WorkspaceWindow.getInstance(),0,owner,stack,startpath);
		if(oldWebDavDownLoadEvent != null){
			webDavChooser.setLockToken(oldWebDavDownLoadEvent.getLockToken());
		}
		// EBhËʒufBXvC̒Sɐݒ
		webDavChooser.setLocationRelativeTo(null);
		if(webDavChooser.isError()){
			return;
		}
		webDavChooser.setVisible(true);
		WebDavDownLoadEvent webDavDownLoadEvent = webDavChooser.getWebDavChooserEvent();
		if(webDavDownLoadEvent == null){
			return;
		}
		if(webDavChooser.isCancel()){
			return;
		}
		if(webDavChooser.isError()){
			return;
		}
		String file = webDavDownLoadEvent.getDownload();
		WorkspaceWindow.getInstance().setWebDavDownLoadEvent(webDavDownLoadEvent);
		WorkspaceWindow.getInstance().restore(new File(file));
		if(oldWebDavDownLoadEvent != null){
			if(webDavDownLoadEvent.isUnlock()){
				WebDavProcessor webDavProcessor = WebDavProcessor.getInstance();
				if(webDavProcessor == null){
		        	JOptionPane.showMessageDialog(
							new JFrame() , "It failed in login to WebDAV." , "fatal" ,
							JOptionPane.ERROR_MESSAGE
						);
		        	return;
				}
				String unlockpath = oldWebDavDownLoadEvent.getDownloadpath();
				String unlockname = oldWebDavDownLoadEvent.getDownloaname();
				String locktoken = oldWebDavDownLoadEvent.getLockToken();
				try {
					webDavProcessor.unlock(unlockpath, unlockname, locktoken);
				} catch (IOException e1) {
					// TODO ꂽ catch ubN
					e1.printStackTrace();
				}
			}
		}
		window.setLastsave(1);
		window.setUpdated(false);
	}

	public void save(){
		WorkspaceWindow window = WorkspaceWindow.getInstance();
		Preference preference = Preference.getInstance().getInstance();
		String owner = preference.getUserName();
		if(owner == null){
			owner = "";
		}
		if(owner.equals("")){
			owner = "unknown user";
		}
		boolean updated = window.isUpdated();
		File file = new File(GSConstants.TEMP_PATH  + "temp.gs");
		window.saveAll(file);
		Stack stack = null;
		String startpath = null;
		WebDavDownLoadEvent oldWebDavDownLoadEvent = WorkspaceWindow.getInstance().getWebDavDownLoadEvent();
		if(oldWebDavDownLoadEvent != null){
			Stack stack_ = oldWebDavDownLoadEvent.getStack();
			if(stack_ != null){
				if(stack_.size() != 0){
					stack = new Stack();
					// X^bN̓Rs[
					for(int i=0;i<stack_.size();i++){
						stack.add(stack_.get(i));
					}
					
				}
			}
			startpath = oldWebDavDownLoadEvent.getDownloadpath();
		}
		WebDavChooser webDavChooser = new WebDavChooser(WorkspaceWindow.getInstance(),1,owner,stack,startpath);
		if(oldWebDavDownLoadEvent != null){
			webDavChooser.setLockToken(oldWebDavDownLoadEvent.getLockToken());
		}
		WebDavUploadLoadEvent webDavUploadLoadEvent = new WebDavUploadLoadEvent();
		webDavUploadLoadEvent.setUploadfile(file);
		File currentFile = window.getCurrentFile();
		String uploadname = "";
		if(window.getLastsave() == 0){
			if(currentFile != null){
				uploadname = currentFile.getName();
			}
		}else if(window.getLastsave() == 1){
			uploadname = oldWebDavDownLoadEvent.getDownloaname();
		}
		webDavUploadLoadEvent.setUploadname(uploadname);
		if(oldWebDavDownLoadEvent != null){
			webDavUploadLoadEvent.setReadonly(oldWebDavDownLoadEvent.isReadonly());
		}
		webDavChooser.setWebDavUploadLoadEvent(webDavUploadLoadEvent);
		// EBhËʒufBXvC̒Sɐݒ
		webDavChooser.setLocationRelativeTo(null);
		if(webDavChooser.isError()){
			return;
		}
		webDavChooser.setVisible(true);
		WebDavDownLoadEvent webDavDownLoadEvent = webDavChooser.getWebDavChooserEvent();
		if(webDavDownLoadEvent == null){
			window.setUpdated(updated);
			return;
		}
		if(webDavChooser.isCancel()){
			window.setUpdated(updated);
			return;
		}
		if(webDavChooser.isError()){
			window.setUpdated(updated);
			return;
		}
		WorkspaceWindow.getInstance().setWebDavDownLoadEvent(webDavDownLoadEvent);
		if(oldWebDavDownLoadEvent != null){
			if(webDavDownLoadEvent.isUnlock()){
				WebDavProcessor webDavProcessor = WebDavProcessor.getInstance();
				if(webDavProcessor == null){
		        	JOptionPane.showMessageDialog(
							new JFrame() , "It failed in login to WebDAV." , "fatal" ,
							JOptionPane.ERROR_MESSAGE
						);
		        	return;
				}
				String unlockpath = oldWebDavDownLoadEvent.getDownloadpath();
				String unlockname = oldWebDavDownLoadEvent.getDownloaname();
				String locktoken = oldWebDavDownLoadEvent.getLockToken();
				try {
					webDavProcessor.unlock(unlockpath, unlockname, locktoken);
				} catch (IOException e1) {
					// TODO ꂽ catch ubN
					e1.printStackTrace();
				}
			}
		}
		window.setLastsave(1);
		window.setUpdated(false);
	}

	public void sync(){
		WorkspaceWindow window = WorkspaceWindow.getInstance();
		Preference preference = Preference.getInstance().getInstance();
		String owner = preference.getUserName();
		if(owner == null){
			owner = "";
		}
		if(owner.equals("")){
			owner = "unknown user";
		}
		ArrayList checkOpenList = new ArrayList();
	    checkOpenList.add(preference.getDscFolderPath());
	    checkOpenList.add(preference.getImageFolderPath());

		WebDavSyncChooser webDavChooser = new WebDavSyncChooser(WorkspaceWindow.getInstance(),owner,null,null);
		webDavChooser.setCheckOpenList(checkOpenList);

		// EBhËʒufBXvC̒Sɐݒ
		webDavChooser.setLocationRelativeTo(null);
		if(webDavChooser.isError()){
			return;
		}
		webDavChooser.setVisible(true);

	}

}
