package smart_gs.swingui.tree.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import smart_gs.logical.Preference;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.StringUtils;

public class AddDirectoryAction extends AddSheetAction{
	
	public AddDirectoryAction(File openDirectory,SpreadTree tree,SpreadDirectory spreadDirectory){
		super(openDirectory, tree, spreadDirectory);
	}
	
	public void actionPerformed(ActionEvent e) {
		JFileChooser chooser = new JFileChooser(openDirectory);
		chooser.setMultiSelectionEnabled(true);
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

		int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
		if (input == JFileChooser.CANCEL_OPTION) {
			return;
		}
	
		File files[] = chooser.getSelectedFiles();
		addDirs(files);
	}
	public void addDirs(File[] files) {
		int size = files.length;

		for (int count = 0; count <size; count++) {
			this.addDir(files[count]);
		}
	}
	public void addDir(File file) {
		String imagepath = Preference.getInstance().getInstance().getImageFolderPath();
		File imageFolder = new File(Preference.getInstance().getInstance().getImageFolderPath());
		imagepath = StringUtils.replaceString(imagepath, "\\", "/");
		imagepath = StringUtils.replaceString(imagepath, "//", "/");

		if(file != null){
			String dir1 = openDirectory.getAbsolutePath();
			String dir2 = imageFolder.getAbsolutePath();
			String dir3 = file.getAbsolutePath();
			dir1 = StringUtils.replaceString(dir1, "\\", "/");
			dir1 = StringUtils.replaceString(dir1, "./", "/");
			dir1 = StringUtils.replaceString(dir1, "//", "/");
			dir2 = StringUtils.replaceString(dir2, "\\", "/");
			dir2 = StringUtils.replaceString(dir2, "./", "/");
			dir2 = StringUtils.replaceString(dir2, "//", "/");
			dir3 = StringUtils.replaceString(dir3, "\\", "/");
			dir3 = StringUtils.replaceString(dir3, "./", "/");
			dir3 = StringUtils.replaceString(dir3, "//", "/");

			boolean check = true;
			if(!dir1.toLowerCase().startsWith(dir2.toLowerCase())){
				check = false;
			}
			if(!dir3.toLowerCase().startsWith(dir1.toLowerCase())){
				check = false;
			}
			if(!check){
				int answer = JOptionPane.showConfirmDialog(new Frame(), "Only a folder in or below the image folder can be added.  ","Information",JOptionPane.DEFAULT_OPTION);
				return;
			}
			if(!imagepath.endsWith("/")){
				imagepath+="/";
			}
			if(!dir1.equals(dir2)){
				String rootpath = dir1.substring(dir1.indexOf(dir2) + dir2.length() ,dir1.length());
				StringBuffer sb = new StringBuffer();
				boolean delete = true;
				for(int i=0;i<rootpath.length();i++){
					if(delete){
						if(rootpath.charAt(i) != '/'){
							delete = false;
						}
					}
					if(!delete){
						sb.append(rootpath.charAt(i));
					}
				}
				imagepath+=sb.toString();
			}
			if(!imagepath.endsWith("/")){
				imagepath+="/";
			}
			{
				String addPath = dir3.substring(dir3.indexOf(dir1) + dir1.length() ,dir3.length());
				StringBuffer sb = new StringBuffer();
				boolean delete = true;
				for(int i=0;i<addPath.length();i++){
					if(delete){
						if(addPath.charAt(i) != '/'){
							delete = false;
						}
					}
					if(!delete){
						sb.append(addPath.charAt(i));
					}
				}
				file = new File(imagepath + sb.toString());				
			}
			File top = new File(imagepath);
			addAll(top,file);
		}
	}
	
	public void addAll(File top,File parent){
		String dir1 = top.getPath();
		dir1 = StringUtils.replaceString(dir1, "\\", "/");
		dir1 = StringUtils.replaceString(dir1, "//", "/");
		{
			// String dir2 = parent.toString();
			String dir2 = parent.getPath();
			dir2 = StringUtils.replaceString(dir2, "\\", "/");
			dir2 = StringUtils.replaceString(dir2, "//", "/");
			dir2 = StringUtils.replaceString(dir2, "\\", "/");
			addImage(dir1, dir2,parent);
		}
		File [] list = parent.listFiles();
		for( int i = 0; i < list.length; i++){
			if(list[i].isDirectory()){
				addAll(top,list[i]);
			}else{
				String dir2 = list[i].getPath();
				dir2 = StringUtils.replaceString(dir2, "\\", "/");
				dir2 = StringUtils.replaceString(dir2, "//", "/");
				dir2 = StringUtils.replaceString(dir2, "\\", "/");
				dir2 = dir2.substring(0,dir2.lastIndexOf("/"));
				addImage(dir1, dir2, list[i]);
			}
		}

	}
}
