package smart_gs.swingui;

import java.awt.Component;

import smart_gs.GSConstants;
import smart_gs.PreferenceManager;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.smleditor.swingui.GSTabbedPane;
import smart_gs.swingui.toolbar.GSEditorToolBar;

@SuppressWarnings("serial")
public class WorkspaceTabbedPane extends GSTabbedPane {
	protected GSEditorToolBar gsEditorToolBar;

	public WorkspaceTabbedPane() {
		super();
	}

	public WorkspaceTabbedPane(GSEditorFrame parent, Spread spread) {
		super(parent, spread);
		this.remove(this.getMainPanel());
	}

	public Component getMainPanel() {
		int type = PreferenceManager.getInstance().getMainDocumentType();
		if (type == GSConstants.IMAGE) {
			return this.canvas;
		} else if (type == GSConstants.FIRSTIDAT) {
			return this.firstIDATPanel;
		} else if (type == GSConstants.THIRDIDAT) {
			return this.thirdIDATPanel;
		} else if (type == GSConstants.SECONDIDAT) {
			return this.secondIDATPanel;
		}
		return null;
	}

	public GSEditorToolBar getGsEditorToolBar() {
		return gsEditorToolBar;
	}

	public void setGsEditorToolBar(GSEditorToolBar gsEditorToolBar) {
		this.gsEditorToolBar = gsEditorToolBar;
	}

}
