package smart_gs.swingui;
//20070921 shimizu wrote;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;


import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.menu.RightClickMenu;
import smart_gs.menu.RightClickMenu2;
import smart_gs.swingui.toolbar.action.ShowSpreadAction;
import smart_gs.smleditor.swingui.GSTextEditor;
import smart_gs.smleditor.swingui.GSTreeTextEditor;
import smart_gs.logical.UsersNoteTree;
import smart_gs.logical.UsersNote;

@SuppressWarnings("serial")
public class UsersNotePanel extends JPanel implements MouseListener{
 private UsersNoteTree tree;
	
	
	public UsersNotePanel(){
		this.setLayout(new BorderLayout());
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.getVerticalScrollBar().setUnitIncrement(20);
		this.tree = UsersNoteTree.getInstance();
		scrollPane.addMouseListener(this);
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		JPanel tree_panel = new JPanel();
		tree_panel.setLayout(new FlowLayout(FlowLayout.LEFT));
		tree_panel.setBackground(Color.white);
		tree_panel.add(tree);
		tree_panel.setBorder(BorderFactory.createLineBorder(Color.BLACK,2));
		tree.addMouseListener(this);
		
		JPanel button_panel = new JPanel();
		JButton show = new JButton("Show");
		show.addActionListener(new ShowSpreadAction());
        button_panel.add(show);
        
        panel.add(tree_panel,BorderLayout.CENTER);

		scrollPane.setViewportView(panel);
		this.add(scrollPane,BorderLayout.CENTER);
		this.add(button_panel,BorderLayout.SOUTH);
	}

	public void mouseClicked(MouseEvent e) {
		if(e.getButton() == MouseEvent.BUTTON3){
			//20071101 shimizu wrote
			UsersNote usersNote = this.tree.getSelectedUsersNote();
			if(usersNote == null){
			JPopupMenu menu = new RightClickMenu();
			menu.show(e.getComponent(),e.getPoint().x,e.getPoint().y);
			}else{
			JPopupMenu menu = new RightClickMenu2();
			menu.show(e.getComponent(),e.getPoint().x,e.getPoint().y);
			}
		}
		else if(e.getClickCount() == 2){
			UsersNote usersNote = this.tree.getSelectedUsersNote();
			if(usersNote == null){
				return;
			}
			//2007/11/1 kazuhiro kobayashi
			//2008/9/19 North Grid GSTextEditor -> GSTreeTextEditor
			GSTreeTextEditor editor = new GSTreeTextEditor(usersNote, usersNote.getName());
			editor.setVisible(true);
			
		}
	}
	public void mouseEntered(MouseEvent arg0) {
	}

	public void mouseExited(MouseEvent arg0) {
	}

	public void mousePressed(MouseEvent arg0) {
	}

	public void mouseReleased(MouseEvent arg0) {
	}
}

