package smart_gs.spread_selection;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.smleditor.swingui.GSEditor;
//import smart_gs.spread_selection.SpreadSelectionTree.CheckBoxNode;
import smart_gs.swingui.SheetSelectPopupMenu;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.ShowSpreadAction;

public class SpreadSelectionTreePanel extends JPanel implements MouseListener{
	
	private SpreadSelectionTree tree;
	private JScrollPane scrollPane;
	
	private SpreadTree spreadTree = SpreadTree.getInstance();
	
	public SpreadSelectionTreePanel(SpreadSelectionTree givenTree){
		this.setLayout(new BorderLayout());
		scrollPane = new JScrollPane();
		scrollPane.getVerticalScrollBar().setUnitIncrement(20);
		this.tree = givenTree;
		scrollPane.addMouseListener(this);
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		JPanel tree_panel = new JPanel();
		tree_panel.setLayout(new FlowLayout(FlowLayout.LEFT));
		tree_panel.setBackground(Color.white);
		tree_panel.add(tree);
		tree_panel.setBorder(BorderFactory.createLineBorder(Color.BLACK,2));
		tree.addMouseListener(this);
     
        panel.add(tree_panel,BorderLayout.CENTER);

		scrollPane.setViewportView(panel);
		this.add(scrollPane,BorderLayout.CENTER);
		
		tree.addMouseListener(ml);
	}
	
	MouseListener ml = new MouseAdapter() {
		public void mousePressed(MouseEvent e) {
			int selRow = tree.getRowForLocation(e.getX(), e.getY());
			TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
			int clickCount = e.getClickCount();
			if (selRow != -1) {
				if (e.getButton() == 3) {
					if (selPath != null) {
						Object lastComponent = selPath.getLastPathComponent();
						DefaultMutableTreeNode node = (DefaultMutableTreeNode) lastComponent;
						Object userObj = node.getUserObject();
						if (userObj instanceof CheckBoxNode) {
							Spread spread = 
								spreadTree.getSpreadByIndex(((CheckBoxNode) userObj).getIndex());
							if (spread != null) {
								if (clickCount == 2) {
									// Is this save necessary? Perhaps... shayashi
									WorkspaceWindow.getInstance().tabbedPaneSave();
									GSEditor editor = new GSEditor(spread);
									editor.setVisible(true);
									return;
								}
							}
						} else {
							JPopupMenu menu = new SpreadSelectionTreeDirectoryPopupMenu(tree, node);
							menu.show(e.getComponent(),e.getX(),e.getY());
							return;
						}
					}
				}
			}
		}
	};
								
//	@Override
	public void mouseClicked(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}
//	@Override
	public void mouseEntered(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}
//	@Override
	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}
//	@Override
	public void mousePressed(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}
//	@Override
	public void mouseReleased(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}
}