package smart_gs.smleditor.swingui;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;

import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.logical.Region;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.util.ImageCropper;

public class CloseUpViewer implements MouseListener {

	int magnification = 20;
	
	JFrame frame = new JFrame();
	JPanel current_panel = new JPanel();
	Image original_image;
	JPanel panel_100 = new JPanel();
	JPanel panel_150 = new JPanel();
	JPanel panel_200 = new JPanel();
	JPanel panel_300 = new JPanel();

    public CloseUpViewer (Image arg) {
    	frame.setAlwaysOnTop(true);
    	original_image = arg;
    	frame.addMouseListener(this);
        
    	try {
    		panel_100 = createElementViewPanelMagnified(100);
    	} catch (NoWayToShowException e){
    		e.printStackTrace();
    	}
    	try {
    		panel_150 = createElementViewPanelMagnified(150);
    	} catch (NoWayToShowException e){
    		e.printStackTrace();
    	}
    	try {
    		panel_200 = createElementViewPanelMagnified(200);
    	} catch (NoWayToShowException e){
    		e.printStackTrace();
    	}
    	try {
    		panel_300 = createElementViewPanelMagnified(300);
    	} catch (NoWayToShowException e){
    		e.printStackTrace();
    	}
    	
    	current_panel = panel_100;
    	frame.getContentPane().add(current_panel, BorderLayout.CENTER);
    	frame.pack();
    	frame.setVisible(true);
    }

	@Override
	public void mouseClicked(MouseEvent e) {
		   JPopupMenu menu = new JPopupMenu();
			JMenuItem title = new JMenuItem("Magnify");
			menu.add(title);
			menu.addSeparator();
			JMenuItem onehundred = new JMenuItem("100%");
			menu.add(onehundred);
			JMenuItem onehundredfifty = new JMenuItem("150%");
			menu.add(onehundredfifty);
			JMenuItem twohundred = new JMenuItem("200%");
			menu.add(twohundred);
			JMenuItem threehundred = new JMenuItem("300%");
			menu.add(threehundred);
			
			onehundred.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					frame.remove(current_panel);
					frame.add(panel_100);
					current_panel = panel_100;
					frame.pack();
					frame.setVisible(true);
					frame.repaint();
				}
			});
			
			onehundredfifty.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					frame.remove(current_panel);
					frame.add(panel_150);
					current_panel = panel_150;
					frame.pack();
					frame.setVisible(true);
					frame.repaint();
				}
			});
			
			twohundred.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					frame.remove(current_panel);
					frame.add(panel_200);
					current_panel = panel_200;
					frame.pack();
					frame.setVisible(true);
					frame.repaint();
				}
			});
			
			threehundred.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					frame.remove(current_panel);
					frame.add(panel_300);
					current_panel = panel_300;
					frame.pack();
					frame.setVisible(true);
					frame.repaint();
				}
			});
			
			menu.show(e.getComponent(), e.getX(), e.getY());
	}

	@Override
	public void mouseEntered(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseExited(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mousePressed(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseReleased(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	
	public JPanel createElementViewPanelMagnified(int percent) throws NoWayToShowException {
		Image resulted_image;
		int width = original_image.getWidth(null);
		resulted_image = original_image.getScaledInstance((int)(width*(percent/100.00)*0.8),-1,Image.SCALE_SMOOTH);
		JLabel label = new JLabel();
		ImageIcon icon = new ImageIcon(resulted_image);
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		label.setIcon(icon);
		panel.add(label,BorderLayout.CENTER);
		return panel;
	}
}

